package  com.amity.socialcloud.sdk.model.core.user

import android.os.Parcelable
import com.amity.socialcloud.sdk.api.core.events.AmityTopicSubscription
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.model.core.events.AmityTopic
import com.amity.socialcloud.sdk.model.core.events.AmityUserEvents
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.amity.types.ObjectId
import org.joda.time.DateTime


@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityUser internal constructor(
    internal val mid: String,
    private val userId: String = ObjectId.get().toHexString(),
    private val displayName: String? = null,
    private val roles: AmityRoles? = null,
    private val flagCount: Int = 0,
    private val metadata: JsonObject? = null,
    internal val avatarFileId: String?,
    internal var avatar: AmityImage? = null,
    private val avatarCustomUrl: String?,
    private val description: String,
    internal var isFlaggedByMe: Boolean = false,
    private val createdAt: DateTime,
    private val updatedAt: DateTime,
    private val isGlobalBan: Boolean,
    private val isDeleted: Boolean,
    private val isBrand: Boolean,
    internal val path: String,
    internal var lastHeartbeat: DateTime? = null,
) : Parcelable, ReactorObject {

    fun getUserId(): String {
        return userId
    }

    fun getDisplayName(): String? {
        return displayName
    }

    fun getRoles(): AmityRoles {
        return roles ?: AmityRoles()
    }

    fun getFlagCount(): Int {
        return flagCount
    }

    fun getMetadata(): JsonObject? {
        return metadata
    }

    fun getAvatar(): AmityImage? {
        return avatar
    }

    fun getAvatarCustomUrl(): String? {
        return avatarCustomUrl
    }

    fun getDescription(): String {
        return description
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

    /* begin_public_function
      id: user.check_flag_by_me
      api_style: async
    */
    fun isFlaggedByMe(): Boolean {
        return isFlaggedByMe
    }
    /* end_public_function */


    fun isGlobalBan(): Boolean {
        return isGlobalBan
    }

    fun isDeleted(): Boolean {
        return isDeleted
    }

    fun isBrand(): Boolean {
        return isBrand
    }

    override fun updatedAt(): DateTime {
        return updatedAt
    }

    override fun uniqueId(): String {
        return userId
    }

    fun subscription(events: AmityUserEvents): AmityTopicSubscription {
        return AmityTopicSubscription(AmityTopic.USER(this, events))
    }

    fun getLastHeartbeat(): DateTime? {
        return lastHeartbeat
    }

}
