package com.amity.socialcloud.sdk.model.social.member

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.model.core.permission.AmityPermissions
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityCommunityMember internal constructor(
    private val communityId: String = ObjectId.get().toHexString(),
    private val userId: String,
    private val channelId: String,
    private val isBanned: Boolean,
    private var roles: AmityRoles,
    private var permissions: AmityPermissions,
    private val createdAt: DateTime,
    private val updatedAt: DateTime,
    internal var user: AmityUser?
) : Parcelable, ReactorObject {

    fun getCommunityId(): String {
        return communityId
    }

    fun getUserId(): String {
        return userId
    }

    fun getChannelId(): String {
        return channelId
    }

    fun isBanned(): Boolean {
        return isBanned
    }

    fun getUser(): AmityUser? {
        return user
    }

    fun getRoles(): AmityRoles {
        return roles
    }

    fun getCreatedAt() : DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

    override fun updatedAt(): DateTime {
        return updatedAt
    }

    override fun uniqueId(): String {
        return userId
    }
}