package com.amity.socialcloud.sdk.video.data.stream

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.keycreator.StreamKeyCreator
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface AmityStreamPagingDao : DynamicQueryStreamPagingDao<EkoStreamEntity> {

    @RawQuery(observedEntities = [EkoStreamEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, EkoStreamEntity>
    
    fun queryStreamList(
        statuses: List<String>
    ): PagingSource<Int, EkoStreamEntity> {
        return queryPagingData(
                generateQueryStreamSQL(
                        tableName = "stream",
                        primaryKeyColumnName = "streamId",
                        dynamicQueryStreamKeyCreator = StreamKeyCreator(statuses),
                        nonce = AmityNonce.STREAM_LIST,
                        order = AmityPagingDao.Order.ASC
                )
        )
    }
}