package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "channel_unread", primaryKeys = ["channelId"])
open class ChannelUnreadEntity : EkoObject() {

    var channelId: String = ObjectId.get().toHexString()
    var unreadCount : Int = 0
    var isMentioned: Boolean = false
    var readToSegment: Int? = null
    var lastSegment: Int = 0
    var lastMentionedSegment: Int? = null
    var isDeleted: Boolean = false

    override fun getId(): String {
        return channelId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is ChannelUnreadEntity
            && Objects.equal(channelId, other.channelId)
            && Objects.equal(unreadCount, other.unreadCount)
            && Objects.equal(isMentioned, other.isMentioned)
            && Objects.equal(createdAt, other.createdAt)
            && Objects.equal(updatedAt, other.updatedAt)
            && Objects.equal(readToSegment, other.readToSegment)
            && Objects.equal(lastSegment, other.lastSegment)
            && Objects.equal(lastMentionedSegment, other.lastMentionedSegment)
            && Objects.equal(isDeleted, other.isDeleted)
            )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            channelId,
            unreadCount,
            isMentioned,
            createdAt,
            updatedAt,
            readToSegment,
            lastSegment,
            lastMentionedSegment,
            isDeleted,
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("channelId", channelId)
            add("unreadCount", unreadCount)
            add("isMentioned", isMentioned)
            add("createdAt", createdAt)
            add("updatedAt", updatedAt)
            add("readToSegment", readToSegment)
            add("lastSegment", lastSegment)
            add("lastMentionedSegment", lastMentionedSegment)
            add("isDeleted", isDeleted)
        }
        return super.internalToString(toStringHelper)
    }

}