package com.ekoapp.ekosdk.internal.api.http.request;

import android.os.Build;

import com.ekoapp.ekosdk.sdk.BuildConfig;
import com.google.gson.annotations.SerializedName;

import org.apache.commons.lang3.StringUtils;

public class RegisterDeviceRequest {

    @SerializedName("userId")
    String userId;

    @SerializedName("displayName")
    String displayName;

    @SerializedName("deviceId")
    String deviceId;

    @SerializedName("authToken")
    String authToken;

    @SerializedName("deviceInfo")
    DeviceInfo deviceInfo = new DeviceInfo();


    public String getUserId() {
        return userId;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public DeviceInfo getDeviceInfo() {
        return deviceInfo;
    }

    public String getAuthToken() {
        return authToken;
    }


    public static RegisterDeviceRequest create(String userId, String displayName, String deviceId, String authToken) {
        RegisterDeviceRequest request = new RegisterDeviceRequest();
        request.userId = userId;
        request.displayName = displayName;
        request.deviceId = deviceId;
        request.authToken = authToken;
        return request;
    }


    public static class DeviceInfo {

        @SerializedName("kind")
        final String kind = "android";

        @SerializedName("model")
        final String model = String.format("%s %s", StringUtils.capitalize(Build.BRAND), Build.MODEL);

        @SerializedName("fingerprint")
        final String fingerprint = Build.FINGERPRINT;

        @SerializedName("android")
        final String android = Build.VERSION.RELEASE;

        @SerializedName("api")
        final String api = String.valueOf(Build.VERSION.SDK_INT);

        @SerializedName("sdkVersion")
        final String sdkVersion = BuildConfig.VERSION_NAME;

        public String getKind() {
            return kind;
        }

        public String getModel() {
            return model;
        }

        public String getFingerprint() {
            return fingerprint;
        }

        public String getAndroidVersion() {
            return android;
        }

        public String getApiLevel() {
            return api;
        }

        public String getSdkVersion() {
            return sdkVersion;
        }
    }
}
