package com.ekoapp.ekosdk.internal.api.http.request

import com.ekoapp.ekosdk.internal.api.http.request.StreamSession
import com.google.gson.annotations.SerializedName

class StreamSession {
	@SerializedName("sessionId")
	var sessionId: String? = null
		private set
	
	@SerializedName("streamId")
	var streamId: String? = null
		private set
	
	@SerializedName("startTime")
	var startTime: String? = null
		private set
	
	@SerializedName("endTime")
	var endTime: String? = null
		private set
	
	@SerializedName("watchSeconds")
	var watchSeconds: Long = 0
		private set
	
	@SerializedName("resolution")
	var resolution: String? = null
		private set
	
	companion object {
		fun create(sessionId: String?, streamId: String?, startTime: String?,
		           endTime: String?, watchSeconds: Long, resolution: String?): StreamSession {
			val request = StreamSession()
			request.sessionId = sessionId
			request.streamId = streamId
			request.startTime = startTime
			request.endTime = endTime
			request.watchSeconds = watchSeconds
			request.resolution = resolution
			return request
		}
	}
}