package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.ekoapp.ekosdk.internal.data.converter.EkoGson.get
import com.google.common.base.Strings
import com.google.gson.JsonArray

class JsonArrayTypeConverter {
	@TypeConverter
	fun stringToJsonObject(json: String?): JsonArray {
		return if (Strings.isNullOrEmpty(json)) {
			JsonArray()
		} else get().fromJson(json, JsonArray::class.java)
	}
	
	@TypeConverter
	fun jsonObjectToString(jsonArray: JsonArray?): String? {
		return if (jsonArray == null) {
			null
		} else get().toJson(jsonArray)
	}
}