package com.amity.socialcloud.sdk.chat.data.channel

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipEntityMapper
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipLocalDataStore
import com.amity.socialcloud.sdk.chat.data.marker.channel.ChannelMarkerRepository
import com.amity.socialcloud.sdk.chat.data.marker.channel.ChannelUnreadEntityMapper
import com.amity.socialcloud.sdk.chat.data.message.preview.MessagePreviewEntityMapper
import com.amity.socialcloud.sdk.chat.data.message.preview.MessagePreviewRepository
import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto
import io.reactivex.rxjava3.core.Completable


internal class ChannelEventPersister : QueryPersister<ChannelEventDto>() {

    override fun persist(dto: ChannelEventDto): Completable {
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users)))
            .andThen(ChannelMembershipLocalDataStore().saveChannelMembers(ChannelMembershipEntityMapper().map(dto.channelMembershipDtoList), dto.channelDtoList.map { it.channelId }))
            .andThen(ChannelLocalDataStore().saveChannels(ChannelEntityMapper().map(dto.channelDtoList)))
            .andThen(MessagePreviewRepository().saveMessagePreviews(MessagePreviewEntityMapper().let { mapper ->
                val previews = mapper.mapSubChannelInfoToMessagePreview(dto.messagePreviews.map(mapper::toMesssagePreview),dto.subChannelInfos.map(mapper::toSubChannelInfo))
                mapper.map(previews)
            }))
            .andThen(Completable.fromCallable {
                val channelsWithMember = dto.channelDtoList.map { channel ->
                    val channelMemberDto = dto.channelMembershipDtoList.find { channelMember -> channelMember.channelId == channel.channelId && channelMember.userId == AmityCoreClient.getUserId() }
                    Pair(channel, channelMemberDto)
                }
                ChannelMarkerRepository().saveChannelUnread(ChannelUnreadEntityMapper().map(channelsWithMember))
            })
    }

}