package com.amity.socialcloud.sdk.chat.data.channel.reader

import com.amity.socialcloud.sdk.chat.data.channel.ChannelLocalDataStore
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerLocalDataStore
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore
import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers

internal class ChannelReaderRepository {

    fun hasUnreadMention(channelId: String): Boolean {
        val channelReader = ChannelReaderLocalDataStore().getChannelReader(channelId)
        val localReadToSegment = SubChannelMarkerLocalDataStore().getUserSubChannelMarker(channelId)?.readToSegment
        val localLastMentionedSegment = channelReader?.localLastMentionedSegment ?: 0
        return if (localReadToSegment != null) {
            localReadToSegment < localLastMentionedSegment
        } else {
            false
        }
    }

    fun updateLastMentionedSegment(
        channelId: String,
        subChannelId: String,
        mentionees: List<EkoMentioneesDto>,
        segment: Int
    ): Completable {
        return Single.fromCallable {
            val activeUserId = SessionLocalDataStore().getActiveUserId()
            val isDefaultSubChannel =
                ChannelLocalDataStore().getChannelByInternalId(subChannelId) != null
            val hasBeenMentioned = mentionees.find {
                (it.type == AmityMentionType.CHANNEL.apiKey)
                        || (it.userIds?.contains(activeUserId) ?: false)
            } != null
            val shouldUpdateLastMentionedSegment = isDefaultSubChannel && hasBeenMentioned
            shouldUpdateLastMentionedSegment
        }.subscribeOn(Schedulers.io())
            .flatMapCompletable { shouldUpdateLastMentionedSegment ->
                if (shouldUpdateLastMentionedSegment) {
                    Completable.fromAction {
                        ChannelReaderLocalDataStore().updateLocalLastMentionSegment(
                            channelId = channelId,
                            localLastMentionSegment = segment
                        )
                    }
                } else {
                    Completable.complete()
                }
            }
    }

}