package com.amity.socialcloud.sdk.chat.data.channel.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.model.chat.message.MessageReadMembershipFilter
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface MessageReadUsersPagingDao : DynamicQueryStreamPagingDao<UserEntity> {

    @RawQuery(observedEntities = [UserEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, UserEntity>

    fun getMessageReadUsersPagingSource(
        messageId: String,
        memberships: List<MessageReadMembershipFilter>,
    ): PagingSource<Int, UserEntity> {
        val order = AmityPagingDao.Order.ASC
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "user",
                primaryKeyColumnName = "userId",
                nonce = AmityNonce.MESSAGE_READ_USERS,
                order = order,
                dynamicQueryStreamKeyCreator = MessageReadUsersKeyCreator(
                    messageId = messageId,
                    memberships = memberships
                )
            )
        )
    }

}