package com.amity.socialcloud.sdk.chat.data.subchannel.paging

import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

class SubChannelKeyCreator(
    private val channelId: String,
    private val isDeleted: Boolean
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "channelPublicId" to channelId,
            "isDeleted" to isDeleted.toString(),
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement()
    }

    private fun getConditionStatement(): String {
        //isDeleted filter
        val isDeletedFilterStatement = if (isDeleted) {
            " sub_channel.isDeleted = 1"
        } else {
            " sub_channel.isDeleted = 0"
        }
    
        //channel filter
        val channelFilterStatement = " and channelPublicId = \"$channelId\" "
        return "$isDeletedFilterStatement$channelFilterStatement"
    }
}