package com.amity.socialcloud.sdk.chat.domain.marker.channel

import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository
import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.core.ObjectResolverEngine
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers
import java.util.concurrent.TimeUnit

internal class ResolveChannelUnreadInfoUseCase {
	
	fun execute(channelIds: List<String>) {
		Completable.fromCallable {
			// Clear channel unread info cache by channelId when join channel
			// Because the SDK will ignore all of incoming up-to-date unread info
			// when unreadInfo.isDeleted=true (which set to true when leave that channel)
			// So we need to clear the cache to make sure the SDK will fetch the latest unread info
			channelIds.map(SubChannelMarkerRepository()::deleteUnreadInfoCacheByChannelId)
		}
			.delay(1, TimeUnit.SECONDS) // Delay to ensure that all the changes in marker service api is up-to-date
			.onErrorComplete()
			.doOnComplete {
				// Resolve channel unread info by channelId
				CoreClient.resolve(channelIds, ObjectResolverEngine.Companion.ReferenceType.CHANNEL_UNREAD_INFO)
			}
			.doOnError {  }
			.subscribeOn(Schedulers.io())
			.observeOn(AndroidSchedulers.mainThread())
			.subscribe()
	}
}