package com.amity.socialcloud.sdk.chat.domain.subchannel

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository
import com.amity.socialcloud.sdk.model.chat.subchannel.AmitySubChannel
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

class SubChannelPagingDataUseCase {

    fun execute(
        channelId: String,
        excludeMainSubChannel: Boolean,
        isDeleted: Boolean
    ): Flowable<PagingData<AmitySubChannel>> {
        return SubChannelRepository().getSubChannelPagingData(
            channelId,
            excludeMainSubChannel,
            isDeleted
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { subChannel ->
                SubChannelComposerUseCase().execute(subChannel)
            }
        }
    }
}