package com.amity.socialcloud.sdk.core.data.invitation

import com.ekoapp.ekosdk.internal.api.dto.InvitationsQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.CreateInvitationsRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.HTTP
import retrofit2.http.POST
import retrofit2.http.Path
import retrofit2.http.Query

interface InvitationApi {

    @GET("api/v1/invitations")
    fun queryInvitations(
        @Query("type") type: String,
        @Query("targetId") targetId: String,
        @Query("targetType") targetType: String,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<InvitationsQueryDto>

    @GET("api/v1/invitations/me")
    fun queryMyInvitations(
        @Query("type") type: String,
        @Query("targetId") targetId: String? = null,
        @Query("targetType") targetType: String? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<InvitationsQueryDto>

    @POST("api/v1/invitations")
    fun createInvitation(
        @Body request: CreateInvitationsRequest
    ): Single<InvitationsQueryDto>

    @POST("api/v1/invitations/{invitationId}/accept")
    fun acceptInvitation(
        @Path("invitationId") invitationId: String,
    ): Single<JsonObject>

    @POST("api/v1/invitations/{invitationId}/reject")
    fun rejectInvitation(
        @Path("invitationId") invitationId: String,
    ): Single<JsonObject>

    @HTTP(method = "DELETE", path = "api/v1/invitations/{invitationId}")
    fun cancelInvitation(
        @Path("invitationId") invitationId: String,
    ): Single<JsonObject>

}