package com.amity.socialcloud.sdk.core.data.presence.user

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.presence.PresenceLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.UserPresenceListDto
import io.reactivex.rxjava3.core.Completable

internal class UserPresencePersister : QueryPersister<UserPresenceListDto>() {

    override fun persist(dto: UserPresenceListDto): Completable {
        return PresenceLocalDataStore().saveUserPresence(UserPresenceEntityMapper().map(dto.presences))
            .andThen(UserLocalDataStore().saveUserPresence(UserPresenceEntityMapper().map(dto.presences)))
    }
}