package com.amity.socialcloud.sdk.core.data.settings.network.social

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.model.chat.settings.AmityMembershipAcceptanceType
import com.ekoapp.ekosdk.internal.SocialSettingsEntity
import com.ekoapp.ekosdk.internal.api.dto.SocialSettingsDto


internal class SocialSettingsEntityMapper :
    EntityMapper<SocialSettingsDto, SocialSettingsEntity>() {

    override fun map(list: List<SocialSettingsDto>): List<SocialSettingsEntity> {
        return list.map { dto ->
            val entity = SocialSettingsEntity()
            entity.enabled = dto.enabled
            entity.allowAllUserToCreateStory = dto.story?.allowAllUserToCreateStory ?: false
            entity.membershipAcceptance = dto.membershipAcceptance
                    ?: AmityMembershipAcceptanceType.AUTOMATIC.value

            entity
        }
    }
}