package com.amity.socialcloud.sdk.core.domain.user

import com.amity.socialcloud.sdk.core.data.user.UserRepository
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class UserGetNowUseCase {

    fun execute(userId: String) : AmityUser? {
        val user = UserRepository().getUserNow(userId)
        user?.let {
            UserComposerUseCase().execute(it)
        }
        
        return  user
    }

}