package com.amity.socialcloud.sdk.core.session.eventbus

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.net.ConnectivityManager
import android.net.Network
import android.os.Build
import androidx.core.content.ContextCompat.getSystemService
import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.session.model.NetworkConnectionEvent


internal object NetworkConnectionEventPublisher {
	
	fun initPublisher(context: Context) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
			getSystemService(context, ConnectivityManager::class.java)?.registerDefaultNetworkCallback(
					object : ConnectivityManager.NetworkCallback() {
						override fun onAvailable(network: Network) {
							MarkerEventBus.publish(MarkerEvent.NetworkConnection.Connected)
							NetworkConnectionEventBus.publish(NetworkConnectionEvent.Connected)
							super.onAvailable(network)
						}
						
						override fun onLost(network: Network) {
							MarkerEventBus.publish(MarkerEvent.NetworkConnection.Disconnected)
							NetworkConnectionEventBus.publish(NetworkConnectionEvent.Disconnected)
							super.onLost(network)
						}
						
						override fun onUnavailable() {
							MarkerEventBus.publish(MarkerEvent.NetworkConnection.Disconnected)
							NetworkConnectionEventBus.publish(NetworkConnectionEvent.Disconnected)
							super.onUnavailable()
						}
					})
		} else {
			(context.getSystemService(Context.CONNECTIVITY_SERVICE) as? ConnectivityManager)
				?.let { connectivityManager ->
					val receiver = object : BroadcastReceiver() {
						override fun onReceive(context: Context?, intent: Intent?) {
							connectivityManager.activeNetworkInfo?.let {
								if (it.isConnected) {
									MarkerEventBus.publish(MarkerEvent.NetworkConnection.Connected)
									NetworkConnectionEventBus.publish(NetworkConnectionEvent.Connected)
								} else {
									MarkerEventBus.publish(MarkerEvent.NetworkConnection.Disconnected)
									NetworkConnectionEventBus.publish(NetworkConnectionEvent.Disconnected)
								}
							}
						}
					}
					context.registerReceiver(receiver, IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION))
				}
		}
	}

}