package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.chat.data.channel.ChannelEventPersister
import com.amity.socialcloud.sdk.chat.data.channel.ChannelLocalDataStore
import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.core.data.session.SessionRepository
import com.amity.socialcloud.sdk.log.AmityLog
import com.amity.socialcloud.sdk.model.chat.member.AmityMembershipType
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelMembershipDto
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlin.reflect.KClass


internal abstract class ChannelEventListener: MqttEventListener<ChannelEventDto>()  {

    override val type: KClass<ChannelEventDto>
        get() = ChannelEventDto::class

    override fun processEvent(dto: ChannelEventDto) {
        ChannelEventPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnError {
                AmityLog.e(it)
            }
            .subscribe()
    }

    override fun shouldProcessEvent(dto: ChannelEventDto): Boolean {
        var shouldProcessEvent = false
        val channelId = dto.channelDtoList?.first()?.channelId
        channelId?.let {
            shouldProcessEvent = ChannelLocalDataStore().hasInLocal(it)
        }
        return shouldProcessEvent
    }
    
    internal fun isActiveUserRemovedEvent(dto: ChannelEventDto): Boolean {
        return isActiveUserEvent(dto) { it.membership == AmityMembershipType.NONE.apiKey || it.membership == AmityMembershipType.BANNED.apiKey }
    }
    
    internal fun isActiveUserAddedEvent(dto: ChannelEventDto): Boolean {
        return isActiveUserEvent(dto) { it.membership == AmityMembershipType.MEMBER.apiKey }
    }
    
    private fun isActiveUserEvent(dto: ChannelEventDto, condition:(EkoChannelMembershipDto) -> Boolean): Boolean {
        val activeUser = SessionRepository().getActiveUserId()
        return dto.channelMembershipDtoList.find {
            condition(it) && it.userId == activeUser
        } != null
    }

}