package com.amity.socialcloud.sdk.model.social.notification

internal enum class AmityCommunityNotificationEventName(val value: String) {
    POST_CREATED("post.created"),
    POST_REACTED("post.reacted"),
    COMMENT_CREATED("comment.created"),
    COMMENT_REPLIED("comment.replied"),
    COMMENT_REACTED("comment.reacted"),
    STORY_CREATED("story.created"),
    STORY_REACTED("story.reacted"),
    STORY_COMMENT_CREATED("story-comment.created"),
    LIVESTREAM_START("video-streaming.didStart"),
    UNKNOWN_EVENT("unknown");

    companion object {
        fun enumOf(value: String?): AmityCommunityNotificationEventName {
            return values().find { it.value == value } ?: UNKNOWN_EVENT
        }
    }

}