package com.amity.socialcloud.sdk.social.domain.community

import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import com.ekoapp.ekosdk.internal.constants.COMMUNITY_ID
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import io.reactivex.rxjava3.core.Completable

class CommunityAcceptJoinRequestUseCase {
    fun execute(targetId: String, userId: String): Completable {
        EkoPreconditions.checkValidParameter(targetId, COMMUNITY_ID)
        return CommunityRepository().approveJoinRequest(targetId, userId)
    }
}