package com.ekoapp.ekosdk.internal.api.hash;

public class EkoFnv1a implements HashFunction {

    private static final long FNV1_32_INIT = 0x811c9dc5L;


    @Override
    public int hash(byte[] buf, int seed) {
        int hash = (int) FNV1_32_INIT ^ seed;
        for (byte b : buf) {
            hash = multiply(hash ^ b);
        }
        return mix(hash);
    }

    private int multiply(int a) {
        return a + (a << 1) + (a << 4) + (a << 7) + (a << 8) + (a << 24);
    }

    private int mix(int a) {
        a += a << 13;
        a ^= a >>> 7;
        a += a << 3;
        a ^= a >>> 17;
        a += a << 5;
        return a;
    }
}
