package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.ekoapp.ekosdk.internal.data.converter.EkoGson.get

class EkoRolesTypeConverter {
	@TypeConverter
	fun stringToEkoRoles(json: String?): AmityRoles? {
		return json?.let { get().fromJson(it, AmityRoles::class.java) }
	}
	
	@TypeConverter
	fun ekoRolesToString(roles: AmityRoles?): String? {
		return roles?.let(get()::toJson)
	}
}