package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority
import com.ekoapp.ekosdk.internal.entity.AnalyticsEventEntity
import io.reactivex.rxjava3.core.Single

@Dao
abstract class AnalyticsEventDao : EkoObjectDao<AnalyticsEventEntity>() {

    @Query("DELETE from analytics_event")
    abstract override fun deleteAll()

    @Query("select * from analytics_event where userId =:userId and syncPriority = :syncPriority order by createdAt desc limit :limit")
    abstract fun getAnalyticEvents(userId: String,
                                   syncPriority: String,
                                   limit: Int): Single<List<AnalyticsEventEntity>>

    @Query("SELECT count(*) from analytics_event")
    abstract fun getAnalyticEventsCount(): Single<Int>

    @Query("delete from analytics_event where eventId in (select eventId from analytics_event order by createdAt asc limit 1)")
    abstract fun deleteOldestEvent()

    @Query("select * from analytics_event where userId = :id limit 1")
    abstract fun getByIdNowImpl(id: String): AnalyticsEventEntity?

    override fun getByIdNow(id: String): AnalyticsEventEntity? {
        return getByIdNowImpl(id)
    }
}