package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import com.ekoapp.ekosdk.internal.data.model.GLOBAL_FEED_QUERY_TOKEN_TABLE_NAME
import com.ekoapp.ekosdk.internal.data.model.GlobalFeedQueryTokenEntity
import io.reactivex.Completable
import io.reactivex.Maybe


@Dao
abstract class GlobalFeedQueryTokenDao : AmityPagingTokenDao<GlobalFeedQueryTokenEntity> {

    @RawQuery(observedEntities = [GlobalFeedQueryTokenEntity::class])
    abstract override fun queryToken(query: SimpleSQLiteQuery): Maybe<GlobalFeedQueryTokenEntity>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract override fun insertToken(token: GlobalFeedQueryTokenEntity): Completable

    override fun tableName() = GLOBAL_FEED_QUERY_TOKEN_TABLE_NAME

}