package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import androidx.room.ForeignKey
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import com.google.common.base.MoreObjects
import com.google.common.base.Objects

@Entity(tableName = "channel_permission",
		primaryKeys = ["channelId", "userId", "permissionName"],
		foreignKeys = [
			ForeignKey(
				entity = ChannelMembershipEntity::class,
				parentColumns = ["channelId", "userId"],
				childColumns = ["channelId", "userId"],
				onDelete = ForeignKey.CASCADE
			)])
data class ChannelMembershipPermissionEntity constructor(
	val channelId: String,
	val userId: String,
	val permissionName: String,
) : EkoPermissionObject() {
	
	override fun equals(obj: Any?): Boolean {
		if (obj == null) return false
		if (obj === this) return true
		if (obj.javaClass != javaClass) return false
		val other = obj as ChannelMembershipPermissionEntity
		return (Objects.equal(channelId, other.channelId)
				&& Objects.equal(userId, other.userId)
				&& Objects.equal(permissionName, other.permissionName))
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(
				channelId,
				userId,
				permissionName
		)
	}
	
	override fun toString(): String {
		return MoreObjects.toStringHelper(this)
				.add("channelId", channelId)
				.add("userId", userId)
				.add("permissionName", permissionName)
				.toString()
	}
	
	companion object {
		@JvmStatic
        fun create(channelId: String, userId: String, permissionName: String): ChannelMembershipPermissionEntity {
			val channelId = EkoPreconditions.checkValidId(channelId, "channelId")
			val userId = EkoPreconditions.checkValidId(userId, "userId")
			val permissionName = EkoPreconditions.checkValidId(permissionName, "permissionName")
			return ChannelMembershipPermissionEntity(channelId, userId, permissionName)
		}
	}
}