package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import androidx.room.ForeignKey
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import com.google.common.base.MoreObjects
import com.google.common.base.Objects

@Entity(tableName = "community_permission",
		primaryKeys = ["communityId", "userId", "permissionName"],
		foreignKeys = [
			ForeignKey(
				entity = CommunityMembershipEntity::class,
				parentColumns = ["communityId", "userId"],
				childColumns = ["communityId", "userId"],
				onDelete = ForeignKey.CASCADE
			)])
data class CommunityMembershipPermissionEntity constructor(
	val communityId: String,
	val userId: String,
	val permissionName: String
) : EkoPermissionObject() {
	
	override fun equals(obj: Any?): Boolean {
		if (obj == null) return false
		if (obj === this) return true
		if (obj.javaClass != javaClass) return false
		val other = obj as CommunityMembershipPermissionEntity
		return (Objects.equal(communityId, other.communityId)
				&& Objects.equal(userId, other.userId)
				&& Objects.equal(permissionName, other.permissionName))
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(
				communityId,
				userId,
				permissionName
		)
	}
	
	override fun toString(): String {
		return MoreObjects.toStringHelper(this)
				.add("communityId", communityId)
				.add("userId", userId)
				.add("permissionName", permissionName)
				.toString()
	}
	
	companion object {
		@JvmStatic
        fun create(communityId: String, userId: String, permissionName: String): CommunityMembershipPermissionEntity {
			val communityId = EkoPreconditions.checkValidId(communityId, "communityId")
			val userId = EkoPreconditions.checkValidId(userId, "userId")
			val permissionName = EkoPreconditions.checkValidId(permissionName, "permissionName")
			return CommunityMembershipPermissionEntity(communityId, userId, permissionName)
		}
	}
}