/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ekoapp.ekosdk.internal.data.model.EkoPushConfig;
import io.reactivex.rxjava3.core.Flowable;

@Dao
public abstract class EkoPushConfigDao {
    @Query(value="SELECT count(*) from push_config where state = 'registered'")
    abstract Flowable<Integer> countRegisteredConfig();

    public Flowable<Boolean> hasRegisteredConfig() {
        return this.countRegisteredConfig().map(count -> count > 0).distinctUntilChanged();
    }

    @Query(value="SELECT * from push_config where userId = :userId LIMIT 1")
    public abstract Flowable<EkoPushConfig> getPushConfig(String var1);

    @Insert(onConflict=1)
    public abstract void insert(EkoPushConfig var1);

    @Query(value="UPDATE push_config set state = 'unregistered'")
    public abstract void unregisterAll();

    @Query(value="DELETE FROM push_config WHERE userId = :userId and state = 'unregistered'")
    public abstract void clearUnregisteredPushConfigForUser(String var1);
}

