package com.amity.socialcloud.sdk.api.social.poll.create

import com.amity.socialcloud.sdk.model.social.poll.AmityPoll
import com.amity.socialcloud.sdk.model.social.poll.AmityPollAnswer
import com.ekoapp.ekosdk.internal.usecase.post.PollCreateUseCase
import io.reactivex.rxjava3.core.Single

class AmityPollCreator private constructor(
    private val question: String,
    private val answers: List<AmityPollAnswer.Data>,
    private val answerType: AmityPoll.AnswerType,
    private val closedIn: Long?
) {

    /**
     * Creates a poll
     * @return Async pollId as Single<String>
     */
    fun create(): Single<String> {
        return PollCreateUseCase().execute(
            question = question,
            answers = answers,
            answerType = answerType.value,
            closedIn = closedIn
        )
    }

    class Builder(private val question: String) {

        private var answers: List<AmityPollAnswer.Data> = listOf()
        private var answerType: AmityPoll.AnswerType = AmityPoll.AnswerType.SINGLE
        private var closedIn: Long? = null

        /**
         * @param [answers] to indicate the list of possible answers
         * @return the same instance of AmityPollCreator.Builder
         */
        fun answers(answers: List<AmityPollAnswer.Data>): Builder {
            this.answers = answers
            return this
        }

        /**
         * @param [answerType] to select either single or multiple answer type
         * @return the same instance of AmityPollCreator.Builder
         */
        fun answerType(answerType: AmityPoll.AnswerType): Builder {
            this.answerType = answerType
            return this
        }

        /**
         * @param [closedIn] to indicate when the poll closes
         * @return the same instance of AmityPollCreator.Builder
         */
        fun closedIn(closedIn: Long): Builder {
            this.closedIn = closedIn
            return this
        }

        /**
         * Instantiates AmityPollCreator with built params.
         * @return new instance of AmityPollCreator.
         */
        fun build(): AmityPollCreator {
            return AmityPollCreator(question, answers, answerType, closedIn)
        }
    }
}