package com.amity.socialcloud.sdk.infra.mqtt.listener

internal object MqttEventListeners {

    private val listeners = listOf(
        ChannelBanned(),
        ChannelCreated(),
        ChannelDeleted(),
        ChannelJoined(),
        ChannelLeft(),
        ChannelMemberAdded(),
        ChannelMemberRemoved(),
        ChannelUnBanned(),
        ChannelUpdated(),
        ChannelSetMuted(),
        ChannelSetMutedUsers(),
        CommentCreated(),
        CommentDeleted(),
        CommentFlagged(),
        CommentReactionAdded(),
        CommentReactionRemoved(),
        CommentUnflagged(),
        CommentUpdated(),
        // CommunityCreated(), Not supported
        CommunityDeleted(),
        CommunityJoined(),
        CommunityLeft(),
        CommunityUpdated(),
        CommunityUserAdded(),
        CommunityUserBanned(),
        CommunityUserRemoved(),
        CommunityUserUnbanned(),
        CommunityRoleAdded(),
        CommunityRoleRemoved(),
        PostApproved(),
        PostCreated(),
        PostDeclined(),
        PostDeleted(),
        PostFlagged(),
        PostReactionAdded(),
        PostReactionRemoved(),
        PostUnflagged(),
        PostUpdated(),
        UserFlagCleared(),
        UserFlagged(),
        UserUnflagged(),
        UserUpdated(),
        UserDeleted(),
        FollowAccepted(),
        FollowCanceled(),
        FollowCreated(),
        FollowDeclined(),
        FollowDeleted(),
        FollowRequested(),
        FollowUnfollowed(),
        MessageCreated(),
        MessageDeleted(),
        MessageFlagged(),
        MessageReactionAdded(),
        MessageReactionRemoved(),
        MessageUnFlagged(),
        MessageUpdated(),
        SubChannelCreated(),
        SubChannelUpdated(),
        SubChannelDeleted(),
        MarkerMarkedMessage(),
        MarkerUpdated(),
        MarkerUserSync(),
        StoryCreated(),
        StoryDeleted(),
        StoryReactionAdded(),
        StoryReactionRemoved(),
        StreamStarted(),
        StreamStopped(),
        StreamFlagged(),
        StreamRecorded(),
        StreamTerminated(),
        LiveReactionCreated(),
        StreamViewerDidBan(),
        StreamViewerDidUnban(),
    )

    private val listenerMap = generateListenerMap()

    private fun generateListenerMap(): Map<String, MqttEventListener<Any>> {
        val map = mutableMapOf<String, MqttEventListener<Any>>()
        listeners.forEach {
            map.put(it.getEventName(), it as MqttEventListener<Any>)
        }
        return map
    }

    fun getMap(): Map<String, MqttEventListener<Any>> {
        return listenerMap
    }

}