package com.amity.socialcloud.sdk.social.data.category.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.api.social.category.query.AmityCommunityCategorySortOption
import com.amity.socialcloud.sdk.entity.social.category.CommunityCategoryEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface CategoryPagingDao : DynamicQueryStreamPagingDao<CommunityCategoryEntity> {

    @RawQuery(observedEntities = [CommunityCategoryEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, CommunityCategoryEntity>

    fun getCategoryPagingSource(
        sortOption: AmityCommunityCategorySortOption,
        isDeleted: Boolean?,
    ): PagingSource<Int, CommunityCategoryEntity> {
        val order = if(sortOption == AmityCommunityCategorySortOption.LAST_CREATED) AmityPagingDao.Order.DESC else AmityPagingDao.Order.ASC
        val sortColumn = if(sortOption == AmityCommunityCategorySortOption.NAME) null else "createdAt"
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "community_category",
                primaryKeyColumnName = "categoryId",
                nonce = AmityNonce.CATEGORY_LIST,
                sortColumn = sortColumn,
                order = order,
                dynamicQueryStreamKeyCreator = CategoryKeyCreator(
                    sortOption = sortOption,
                    isDeleted = isDeleted
                )
            )
        )
    }

}