package com.amity.socialcloud.sdk.social.data.community

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.entity.comunity.JoinRequestEntity
import com.amity.socialcloud.sdk.model.social.community.AmityJoinRequest
import com.amity.socialcloud.sdk.model.social.community.AmityJoinRequestStatus

class CommunityJoinRequestModelMapper: ModelMapper<JoinRequestEntity, AmityJoinRequest>() {
    override fun map(entity: JoinRequestEntity): AmityJoinRequest {
        return AmityJoinRequest(
            joinRequestId = entity.joinRequestId,
            type = entity.type,
            networkId = entity.networkId,
            targetId = entity.targetId,
            targetType = entity.targetType,
            userId = entity.userId,
            // Requestor information
            requestorId = entity.requestorId,
            requestorInternalId = entity.requestorInternalId,
            requestorPublicId = entity.requestorPublicId,
            // Responder information
            responderId = entity.responderId,
            responderInternalId = entity.responderInternalId,
            responderPublicId = entity.responderPublicId,
            respondedAt = entity.respondedAt,
            createdAt = entity.createdAt,
            updatedAt = entity.updatedAt,
            status = AmityJoinRequestStatus.fromApiKey(entity.status),
        )
    }
}
