package com.amity.socialcloud.sdk.social.data.story

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.entity.social.story.StoryEntity
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagingDao
import io.reactivex.rxjava3.core.Flowable

@Dao
internal interface StorySinglePageDao : QueryStreamPagingDao<StoryEntity> {
    @RawQuery(observedEntities = [StoryEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, StoryEntity>

    @RawQuery(observedEntities = [StoryEntity::class, AmityPagingId::class])
    fun getStoriesByTargetsImpl(query: SimpleSQLiteQuery): Flowable<List<StoryEntity>>

    fun getStoryTargetByTargets(targets: List<Pair<AmityStory.TargetType, String>>): Flowable<List<StoryEntity>> {
        val keyCreator = StorySinglePageKeyCreator(targets = targets)
        val query =  generateQueryStreamSQL(
            tableName = "story",
            primaryKeyColumnName = "uniqueId",
            queryStreamKeyCreator = keyCreator,
            nonce = AmityNonce.STORY_LIST,
            order = AmityPagingDao.Order.ASC
        )
        return getStoriesByTargetsImpl(query)
    }
}