package com.amity.socialcloud.sdk.social.data.storytarget.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.api.social.storytarget.AmityGlobalStoryTargetsQueryOption
import com.amity.socialcloud.sdk.entity.social.story.StoryTargetEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao


@Dao
internal interface StoryTargetPagingDao : DynamicQueryStreamPagingDao<StoryTargetEntity> {
    @RawQuery(observedEntities = [StoryTargetEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, StoryTargetEntity>

    fun getStoryTargetPagingSource(
        option: AmityGlobalStoryTargetsQueryOption
    ): PagingSource<Int, StoryTargetEntity> {
        val sortColumns = if (
            option == AmityGlobalStoryTargetsQueryOption.SEEN
            || option == AmityGlobalStoryTargetsQueryOption.ALL
        ) {
            mutableListOf<AmityPagingDao.Sorting>().apply {
                add(
                    AmityPagingDao.Sorting.Column(
                        tableName = "storyTarget",
                        columnName = "localSortingDate",
                        order = AmityPagingDao.Order.DESC,
                    )
                )
            }
        }
        else {
            mutableListOf<AmityPagingDao.Sorting>().apply {
                add(
                    AmityPagingDao.Sorting.Column(
                        tableName = "storyTarget",
                        columnName = "hasUnseen",
                        order = AmityPagingDao.Order.DESC,
                    )
                )
                add(
                    AmityPagingDao.Sorting.Column(
                        tableName = "storyTarget",
                        columnName = "localSortingDate",
                        order = AmityPagingDao.Order.DESC,
                    )
                )
            }
        }

        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "storyTarget",
                primaryKeyColumnName = "uniqueId",
                nonce = AmityNonce.STORY_TARGET_PAGE,
                sortColumns = sortColumns,
                order = AmityPagingDao.Order.DESC,
                dynamicQueryStreamKeyCreator = StoryTargetKeyCreator(
                    option = option
                )
            )
        )
    }

}