package com.ekoapp.ekosdk.internal.usecase.comment

import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.comment.AmityComment
import com.amity.socialcloud.sdk.social.data.comment.CommentRepository
import com.amity.socialcloud.sdk.social.domain.comment.CommentComposerUseCase
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class CreateCommentUseCase {

    fun execute(
        referenceType: String,
        referenceId: String,
        parentId: String?,
        commentId: String?,
        data: JsonObject?,
        dataTypes: List<String>,
        attachments: JsonArray?,
        metadata: JsonObject?,
        mentionees: List<AmityMentioneeTarget>?
    ): Single<AmityComment> {
        return CommentRepository().createComment(
            referenceType,
            referenceId,
            parentId,
            commentId,
            data,
            dataTypes,
            attachments,
            metadata,
            mentionees
        ).map {
            CommentComposerUseCase().execute(it)
        }
    }

}