/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.message;

import android.net.Uri;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.chat.message.query.AmityMessageQuerySortOption;
import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerRepository;
import com.amity.socialcloud.sdk.chat.data.message.MessageLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.message.MessageModelMapper;
import com.amity.socialcloud.sdk.chat.data.message.MessageQueryPersister;
import com.amity.socialcloud.sdk.chat.data.message.MessageRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository;
import com.amity.socialcloud.sdk.chat.data.message.flag.MessageFlagLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.message.flag.MessageFlagRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.message.paging.MessageMediator;
import com.amity.socialcloud.sdk.chat.domain.marker.message.OptimisticCreateMessageMarkerUseCase;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.MarkerSyncEngine;
import com.amity.socialcloud.sdk.core.MessagePreviewEvent;
import com.amity.socialcloud.sdk.core.MessageSyncEngine;
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore;
import com.amity.socialcloud.sdk.core.session.eventbus.MessagePreviewEventBus;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessageAttachment;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.file.AmityFileInfo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import com.amity.socialcloud.sdk.model.core.flag.AmityContentFlagReason;
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto;
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto;
import com.ekoapp.ekosdk.internal.api.dto.SubChannelDto;
import com.ekoapp.ekosdk.internal.api.socket.request.FlagContentRequest;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.repository.comment.CommentLoadResult;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableEmitter;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 U2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001UB\u0005\u00a2\u0006\u0002\u0010\u0004J^\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\\\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\bJ\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00140\u00172\u0006\u0010\u001a\u001a\u00020\bJ\u0016\u0010!\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020%H\u0002Ji\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010(\u001a\u00020)2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00112\b\u0010,\u001a\u0004\u0018\u00010)2\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020%2\b\b\u0002\u00100\u001a\u00020)\u00a2\u0006\u0002\u00101Jg\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0003030'2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010(\u001a\u00020)2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00112\b\u0010,\u001a\u0004\u0018\u00010)2\b\u00104\u001a\u0004\u0018\u00010\b2\u0006\u00105\u001a\u0002062\b\u0010\r\u001a\u0004\u0018\u000107\u00a2\u0006\u0002\u00108Jj\u00109\u001a\u00020\u0006\"\b\b\u0000\u0010:*\u00020;2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H:0=H\u0002J\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020)0\u00172\u0006\u0010\u001a\u001a\u00020\bJ_\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00105\u001a\u0002062\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010(\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010A\u001a\u00020%\u00a2\u0006\u0002\u0010BJ_\u0010C\u001a\b\u0012\u0004\u0012\u00020@0\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00105\u001a\u0002062\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010(\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010D\u001a\u00020\b\u00a2\u0006\u0002\u0010EJ\u0014\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030GH\u0016J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00020'2\u0006\u0010\u001c\u001a\u00020\bH\u0016J#\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010,\u001a\u0004\u0018\u00010)\u00a2\u0006\u0002\u0010JJ]\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00140'2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010(\u001a\u00020)2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00112\b\u0010,\u001a\u0004\u0018\u00010)2\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u00105\u001a\u000206\u00a2\u0006\u0002\u0010LJ\u0012\u0010M\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\bH\u0016J\\\u0010N\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u000e\u0010O\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\bJ\u001d\u0010P\u001a\u00020Q2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010R\u001a\u00020%H\u0000\u00a2\u0006\u0002\bSJ<\u0010T\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014\u00a8\u0006V"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/message/MessageRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage;", "()V", "createMessage", "Lio/reactivex/rxjava3/core/Completable;", "subChannelId", "", "parentId", "fileUri", "Landroid/net/Uri;", "fileId", "type", "data", "Lcom/google/gson/JsonObject;", "tags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "metadata", "mentionees", "", "Lcom/amity/socialcloud/sdk/model/core/mention/AmityMentioneeTarget;", "createPreviewMessage", "Lio/reactivex/rxjava3/core/Single;", "deleteFailedMessages", "deleteMessage", "messageId", "fetchAndSave", "objectId", "fetchMessageMarker", "dto", "Lcom/ekoapp/ekosdk/internal/api/dto/MessageQueryDto;", "findCacheAroundMessageId", "flagMessage", "reason", "Lcom/amity/socialcloud/sdk/model/core/flag/AmityContentFlagReason;", "getDefaultPageSize", "", "getLatestMessage", "Lio/reactivex/rxjava3/core/Flowable;", "isFilterByParentId", "", "includingTags", "excludingTags", "isDeleted", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "isUnsyncedOnly", "(Ljava/lang/String;ZLjava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Ljava/lang/String;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;IZ)Lio/reactivex/rxjava3/core/Flowable;", "getMessagePagingData", "Landroidx/paging/PagingData;", "aroundMessageId", "sortOption", "Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;", "(Ljava/lang/String;ZLjava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;)Lio/reactivex/rxjava3/core/Flowable;", "handleUploadResult", "T", "Lcom/amity/socialcloud/sdk/model/core/file/AmityFileInfo;", "uploadResult", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "isFlaggedByMe", "loadFirstPageMessages", "Lcom/ekoapp/ekosdk/internal/repository/comment/CommentLoadResult;", "limit", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;Ljava/lang/String;ZLjava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/String;I)Lio/reactivex/rxjava3/core/Single;", "loadMessages", "token", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;Ljava/lang/String;ZLjava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/String;Ljava/lang/String;)Lio/reactivex/rxjava3/core/Single;", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "observeLatestMessage", "(Ljava/lang/String;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Flowable;", "observeMessages", "(Ljava/lang/String;ZLjava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;)Lio/reactivex/rxjava3/core/Flowable;", "queryFromCache", "syncMessage", "unflagMessage", "updateMarkerHash", "", "hash", "updateMarkerHash$amity_sdk_release", "updateMessage", "Companion", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nMessageRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageRepository.kt\ncom/amity/socialcloud/sdk/chat/data/message/MessageRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,570:1\n766#2:571\n857#2,2:572\n1549#2:574\n1620#2,3:575\n*S KotlinDebug\n*F\n+ 1 MessageRepository.kt\ncom/amity/socialcloud/sdk/chat/data/message/MessageRepository\n*L\n539#1:571\n539#1:572,2\n540#1:574\n540#1:575,3\n*E\n"})
public final class MessageRepository
extends AmityObjectRepository<EkoMessageEntity, AmityMessage> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<AmityMessage.DataType> fileUploadingTypes;

    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new MessageRemoteDataStore().getMessage(objectId).flatMapCompletable(new Function(this){
            final /* synthetic */ MessageRepository this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final CompletableSource apply(@NotNull MessageQueryDto dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                return (CompletableSource)MessageRepository.access$fetchMessageMarker(this.this$0, dto).andThen((CompletableSource)new MessageQueryPersister().persist(dto));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"override fun fetchAndSav\u2026dto))\n            }\n    }");
        return completable;
    }

    @Override
    @Nullable
    public EkoMessageEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        EkoMessageEntity message = new MessageLocalDataStore().getMessage(objectId);
        if (message != null && AmityMessage.State.Companion.enumOf(message.getSyncState()) != AmityMessage.State.SYNCED) {
            throw AmityException.Companion.create$default(AmityException.Companion, "Observing unsynced object is not supported by Live Object.", null, AmityError.UNSUPPORTED, null, 8, null);
        }
        return message;
    }

    @Override
    @NotNull
    public ModelMapper<EkoMessageEntity, AmityMessage> mapper() {
        return new MessageModelMapper();
    }

    @Override
    @NotNull
    public Flowable<EkoMessageEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new MessageLocalDataStore().observeMessage(objectId);
    }

    private final int getDefaultPageSize() {
        return 40;
    }

    @NotNull
    public final Completable createMessage(@NotNull String subChannelId, @Nullable String parentId, @Nullable Uri fileUri, @Nullable String fileId, @NotNull String type2, @NotNull JsonObject data, @NotNull AmityTags tags, @Nullable JsonObject metadata, @NotNull List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter(mentionees, (String)"mentionees");
        Completable completable = this.createPreviewMessage(subChannelId, parentId, type2, data, tags, fileUri, metadata, mentionees).flatMapCompletable(new Function(fileId, fileUri){
            final /* synthetic */ String $fileId;
            final /* synthetic */ Uri $fileUri;
            {
                this.$fileId = $fileId;
                this.$fileUri = $fileUri;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoMessageEntity message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return (CompletableSource)Completable.create(arg_0 -> createMessage.1.apply$lambda$0(this.$fileId, message, this.$fileUri, arg_0));
            }

            private static final void apply$lambda$0(String $fileId, EkoMessageEntity $message, Uri $fileUri, CompletableEmitter emitter) {
                Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
                Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
                if ($fileId != null) {
                    CoreClient.INSTANCE.createAttachmentMessage($message, emitter, new AmityMessageAttachment.FILE_ID($fileId));
                } else if ($fileUri != null) {
                    MessageSyncEngine.Companion.grantPersistableUriPermissionIfNeeded($fileUri);
                    CoreClient.INSTANCE.createAttachmentMessage($message, emitter, new AmityMessageAttachment.URL($fileUri));
                } else {
                    CoreClient.INSTANCE.createTextMessage($message, emitter);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fileUri: Uri?,\n        f\u2026}\n            }\n        }");
        return completable;
    }

    public static /* synthetic */ Completable createMessage$default(MessageRepository messageRepository, String string, String string2, Uri uri, String string3, String string4, JsonObject jsonObject, AmityTags amityTags, JsonObject jsonObject2, List list2, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        return messageRepository.createMessage(string, string2, uri, string3, string4, jsonObject, amityTags, jsonObject2, list2);
    }

    private final <T extends AmityFileInfo> Completable handleUploadResult(String messageId, String subChannelId, String parentId, String type2, JsonObject data, AmityTags tags, JsonObject metadata, List<AmityMentioneeTarget> mentionees, AmityUploadResult<? extends T> uploadResult) {
        Completable completable;
        AmityUploadResult<? extends T> amityUploadResult = uploadResult;
        if (amityUploadResult instanceof AmityUploadResult.COMPLETE) {
            String fileId = ((AmityFileInfo)((AmityUploadResult.COMPLETE)uploadResult).getFile()).getFileId();
            completable = this.syncMessage(messageId, subChannelId, parentId, type2, data, tags, fileId, metadata, mentionees);
        } else if (amityUploadResult instanceof AmityUploadResult.ERROR) {
            Completable completable2 = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)((AmityUploadResult.ERROR)uploadResult).getError()));
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n                Messag\u2026etError()))\n            }");
            completable = completable2;
        } else if (amityUploadResult instanceof AmityUploadResult.CANCELLED) {
            Completable completable3 = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, StringsKt.capitalize((String)type2) + " upload cancelled", null, AmityError.UNKNOWN, null, 8, null)));
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"{\n                Messag\u2026          )\n            }");
        } else {
            Completable completable4 = Completable.complete();
            completable = completable4;
            Intrinsics.checkNotNullExpressionValue((Object)completable4, (String)"{\n                Comple\u2026.complete()\n            }");
        }
        return completable;
    }

    @NotNull
    public final Completable syncMessage(@NotNull String messageId, @NotNull String subChannelId, @Nullable String parentId, @NotNull String type2, @NotNull JsonObject data, @NotNull AmityTags tags, @Nullable String fileId, @Nullable JsonObject metadata, @NotNull List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter(mentionees, (String)"mentionees");
        if (data.has("fileId")) {
            data.remove("fileId");
        }
        Completable completable = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.SYNCING).andThen((CompletableSource)new MessageRemoteDataStore().createMessage(messageId, parentId, subChannelId, fileId, type2, data, tags, metadata, mentionees).flatMapCompletable(new Function(messageId){
            final /* synthetic */ String $messageId;
            {
                this.$messageId = $messageId;
            }

            @NotNull
            public final CompletableSource apply(@NotNull MessageQueryDto dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                return (CompletableSource)new OptimisticCreateMessageMarkerUseCase().execute(dto).onErrorComplete().andThen((CompletableSource)new MessageQueryPersister().persist(dto)).andThen((CompletableSource)new MessageLocalDataStore().updateMessageState(this.$messageId, AmityMessage.State.SYNCED)).andThen((CompletableSource)Completable.fromCallable(() -> syncMessage.1.apply$lambda$3(dto)).onErrorComplete());
            }

            /*
             * WARNING - void declaration
             */
            private static final Object apply$lambda$3(MessageQueryDto $dto) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$dto, (String)"$dto");
                Iterable $this$map$iv = $dto.getMessages();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    Unit unit;
                    Object v0;
                    void message;
                    Collection collection;
                    block4: {
                        EkoMessageDto ekoMessageDto = (EkoMessageDto)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Iterable iterable2 = $dto.getSubChannels();
                        for (T t : iterable2) {
                            SubChannelDto it = (SubChannelDto)t;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getSubChannelId(), (Object)message.getSubChannelId())) continue;
                            v0 = t;
                            break block4;
                        }
                        v0 = null;
                    }
                    if ((SubChannelDto)v0 != null) {
                        SubChannelDto subChannel;
                        boolean bl = false;
                        MessagePreviewEventBus.INSTANCE.publish(new MessagePreviewEvent.MessageCreated((EkoMessageDto)message, subChannel));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    collection.add(unit);
                }
                return (List)destination$iv$iv;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"messageId: String,\n     \u2026     )\n                })");
        return completable;
    }

    public static /* synthetic */ Completable syncMessage$default(MessageRepository messageRepository, String string, String string2, String string3, String string4, JsonObject jsonObject, AmityTags amityTags, String string5, JsonObject jsonObject2, List list2, int n, Object object) {
        if ((n & 0x40) != 0) {
            string5 = null;
        }
        return messageRepository.syncMessage(string, string2, string3, string4, jsonObject, amityTags, string5, jsonObject2, list2);
    }

    private final Single<EkoMessageEntity> createPreviewMessage(String subChannelId, String parentId, String type2, JsonObject data, AmityTags tags, Uri fileUri, JsonObject metadata, List<AmityMentioneeTarget> mentionees) {
        Single single = new MessageLocalDataStore().createMessage(subChannelId, parentId, type2, data, metadata, tags, fileUri, mentionees).flatMap(new Function(fileUri){
            final /* synthetic */ Uri $fileUri;
            {
                this.$fileUri = $fileUri;
            }

            @NotNull
            public final SingleSource<? extends EkoMessageEntity> apply(@NotNull EkoMessageEntity message) {
                Completable completable;
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Completable completable2 = new MessageFlagLocalDataStore().createFlag(message.getMessageId());
                if (!MessageRepository.access$getFileUploadingTypes$cp().contains((Object)((Object)message.getDataType()))) {
                    completable = Completable.complete();
                } else {
                    Object object;
                    String fileType;
                    switch (createPreviewMessage.WhenMappings.$EnumSwitchMapping$0[message.getDataType().ordinal()]) {
                        case 1: {
                            String string = AmityMessage.DataType.IMAGE.getApiKey();
                            break;
                        }
                        case 2: {
                            String string = AmityMessage.DataType.VIDEO.getApiKey();
                            break;
                        }
                        case 3: {
                            String string = AmityMessage.DataType.AUDIO.getApiKey();
                            break;
                        }
                        default: {
                            String string = fileType = AmityMessage.DataType.FILE.getApiKey();
                        }
                    }
                    if ((object = this.$fileUri) == null || (object = object.toString()) == null) {
                        object = "";
                    }
                    Object path = object;
                    completable = new FileLocalDataStore().createLocalFile(message.getMessageId(), fileType, (String)path);
                }
                return (SingleSource)completable2.andThen((CompletableSource)completable).andThen((SingleSource)Single.just((Object)message));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fileUri: Uri?,\n        m\u2026.just(message))\n        }");
        return single;
    }

    @NotNull
    public final Flowable<AmityMessage> observeLatestMessage(@NotNull String subChannelId, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Flowable flowable = new MessageLocalDataStore().observeLatestMessage(subChannelId, isDeleted).map((Function)observeLatestMessage.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"MessageLocalDataStore().\u2026r().map(it)\n            }");
        return flowable;
    }

    @NotNull
    public final Completable updateMessage(@NotNull String messageId, @Nullable JsonObject data, @Nullable AmityTags tags, @Nullable JsonObject metadata, @Nullable List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = new MessageRemoteDataStore().updateMessage(messageId, data, tags, metadata, mentionees).flatMapCompletable((Function)updateMessage.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageRemoteDataStore()\u2026          )\n            }");
        return completable;
    }

    @NotNull
    public final Completable deleteMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = Single.fromCallable(() -> MessageRepository.deleteMessage$lambda$0(messageId)).flatMapCompletable(new Function(messageId){
            final /* synthetic */ String $messageId;
            {
                this.$messageId = $messageId;
            }

            @NotNull
            public final CompletableSource apply(@NotNull String deletingId) {
                Intrinsics.checkNotNullParameter((Object)deletingId, (String)"deletingId");
                return ((CharSequence)deletingId).length() > 0 ? (CompletableSource)new MessageRemoteDataStore().deleteMessage(this.$messageId).flatMapCompletable((Function)deleteMessage.1.INSTANCE) : (CompletableSource)new MessageLocalDataStore().hardDeleteMessage(this.$messageId);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"messageId: String): Comp\u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Completable flagMessage(@NotNull String messageId, @NotNull AmityContentFlagReason reason) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        FlagContentRequest request = reason instanceof AmityContentFlagReason.Others ? new FlagContentRequest(reason.getReason(), ((AmityContentFlagReason.Others)reason).getDetails()) : new FlagContentRequest(reason.getReason(), null, 2, null);
        Completable completable = new MessageFlagRemoteDataStore().flagMessage(messageId, request).map((Function)flagMessage.1.INSTANCE).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageFlagRemoteDataSto\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable unflagMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = new MessageFlagRemoteDataStore().unflagMessage(messageId).map((Function)unflagMessage.1.INSTANCE).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageFlagRemoteDataSto\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Flowable<List<AmityMessage>> observeMessages(@NotNull String subChannelId, boolean isFilterByParentId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @Nullable String type2, @NotNull AmityMessageQuerySortOption sortOption) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Flowable flowable = new MessageLocalDataStore().observeMessages(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, type2, sortOption).map((Function)observeMessages.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"MessageLocalDataStore().\u2026)\n            }\n        }");
        return flowable;
    }

    @NotNull
    public final Single<CommentLoadResult> loadFirstPageMessages(@NotNull String subChannelId, @NotNull AmityMessageQuerySortOption sortOption, @Nullable String parentId, boolean isFilterByParentId, @Nullable Boolean isDeleted, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable String type2, int limit) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        MessageRemoteDataStore messageRemoteDataStore = new MessageRemoteDataStore();
        String string = sortOption.getApiKey();
        Single single = MessageRemoteDataStore.queryMessages$default(messageRemoteDataStore, subChannelId, isFilterByParentId, parentId, isDeleted, includingTags, excludingTags, type2, null, limit, string, null, 1152, null).flatMap(new Function(subChannelId, this){
            final /* synthetic */ String $subChannelId;
            final /* synthetic */ MessageRepository this$0;
            {
                this.$subChannelId = $subChannelId;
                this.this$0 = $receiver;
            }

            @NotNull
            public final SingleSource<? extends MessageQueryDto> apply(@NotNull MessageQueryDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (SingleSource)new MessageLocalDataStore().hardDeleteAllFromSubChannel(this.$subChannelId).andThen((CompletableSource)MessageRepository.access$fetchMessageMarker(this.this$0, it)).andThen((CompletableSource)new MessageQueryPersister().persist(it)).andThen((SingleSource)Single.just((Object)it));
            }
        }).map((Function)loadFirstPageMessages.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fun loadFirstPageMessage\u2026 ids)\n            }\n    }");
        return single;
    }

    @NotNull
    public final Single<CommentLoadResult> loadMessages(@NotNull String subChannelId, @NotNull AmityMessageQuerySortOption sortOption, @Nullable String parentId, boolean isFilterByParentId, @Nullable Boolean isDeleted, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable String type2, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Single single = MessageRemoteDataStore.queryMessages$default(new MessageRemoteDataStore(), subChannelId, isFilterByParentId, parentId, isDeleted, includingTags, excludingTags, type2, null, null, sortOption.getApiKey(), token, 384, null).flatMap(new Function(this){
            final /* synthetic */ MessageRepository this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final SingleSource<? extends MessageQueryDto> apply(@NotNull MessageQueryDto dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                return (SingleSource)MessageRepository.access$fetchMessageMarker(this.this$0, dto).andThen((CompletableSource)new MessageQueryPersister().persist(dto)).andThen((SingleSource)Single.just((Object)dto));
            }
        }).map((Function)loadMessages.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fun loadMessages(\n      \u2026 ids)\n            }\n    }");
        return single;
    }

    @NotNull
    public final Flowable<PagingData<AmityMessage>> getMessagePagingData(@NotNull String subChannelId, boolean isFilterByParentId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @Nullable String aroundMessageId, @NotNull AmityMessageQuerySortOption sortOption, @Nullable AmityMessage.DataType type2) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        String uniqueId = aroundMessageId != null ? UUID.randomUUID().toString() : null;
        AmityMessage.DataType dataType = type2;
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, true, 0, 0, 0, 58, null), null, new MessageMediator(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, sortOption, dataType != null ? dataType.getApiKey() : null, aroundMessageId, uniqueId), (Function0)new Function0<PagingSource<Integer, EkoMessageEntity>>(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, sortOption, type2, aroundMessageId, uniqueId){
            final /* synthetic */ String $subChannelId;
            final /* synthetic */ boolean $isFilterByParentId;
            final /* synthetic */ String $parentId;
            final /* synthetic */ AmityTags $includingTags;
            final /* synthetic */ AmityTags $excludingTags;
            final /* synthetic */ Boolean $isDeleted;
            final /* synthetic */ AmityMessageQuerySortOption $sortOption;
            final /* synthetic */ AmityMessage.DataType $type;
            final /* synthetic */ String $aroundMessageId;
            final /* synthetic */ String $uniqueId;
            {
                this.$subChannelId = $subChannelId;
                this.$isFilterByParentId = $isFilterByParentId;
                this.$parentId = $parentId;
                this.$includingTags = $includingTags;
                this.$excludingTags = $excludingTags;
                this.$isDeleted = $isDeleted;
                this.$sortOption = $sortOption;
                this.$type = $type;
                this.$aroundMessageId = $aroundMessageId;
                this.$uniqueId = $uniqueId;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, EkoMessageEntity> invoke() {
                AmityMessage.DataType dataType = this.$type;
                return new MessageLocalDataStore().getMessagePagingSource(this.$subChannelId, this.$isFilterByParentId, this.$parentId, this.$includingTags, this.$excludingTags, this.$isDeleted, this.$sortOption, dataType != null ? dataType.getApiKey() : null, this.$aroundMessageId, this.$uniqueId);
            }
        }, (ModelMapper)new MessageModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<AmityMessage> getLatestMessage(@NotNull String subChannelId, boolean isFilterByParentId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @Nullable String type2, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce, boolean isUnsyncedOnly) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable flowable = new MessageLocalDataStore().getLatestMessage(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, type2, dynamicQueryStreamKeyCreator, nonce, isUnsyncedOnly).map((Function)getLatestMessage.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"MessageLocalDataStore().\u2026r().map(it)\n            }");
        return flowable;
    }

    public static /* synthetic */ Flowable getLatestMessage$default(MessageRepository messageRepository, String string, boolean bl, String string2, AmityTags amityTags, AmityTags amityTags2, Boolean bl2, String string3, DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int n, boolean bl3, int n2, Object object) {
        if ((n2 & 0x200) != 0) {
            bl3 = false;
        }
        return messageRepository.getLatestMessage(string, bl, string2, amityTags, amityTags2, bl2, string3, dynamicQueryStreamKeyCreator, n, bl3);
    }

    @NotNull
    public final Single<Boolean> isFlaggedByMe(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Single single = new MessageFlagRemoteDataStore().isFlaggedByMe(messageId).map((Function)isFlaggedByMe.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"MessageFlagRemoteDataSto\u2026\"isFlagByMe\").asBoolean }");
        return single;
    }

    public final void updateMarkerHash$amity_sdk_release(@NotNull String messageId, int hash) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        new MessageLocalDataStore().updateMarkerHash(messageId, hash);
    }

    /*
     * WARNING - void declaration
     */
    private final Completable fetchMessageMarker(MessageQueryDto dto) {
        void $this$mapTo$iv$iv;
        EkoMessageDto it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = dto.getMessages();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (EkoMessageDto)element$iv$iv;
            boolean bl = false;
            if (!MarkerSyncEngine.Companion.isMarkerSyncSupport(it.getChannelType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (EkoMessageDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMessageId());
        }
        List messageIds = (List)destination$iv$iv;
        boolean bl = false;
        Completable completable = (messageIds.isEmpty() ? Completable.complete() : new MessageMarkerRepository().fetchMessageMarker(messageIds)).onErrorComplete();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"dto.messages\n           \u2026       .onErrorComplete()");
        return completable;
    }

    @NotNull
    public final Completable deleteFailedMessages() {
        Completable completable = Completable.fromCallable(MessageRepository::deleteFailedMessages$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromCallable {\n         \u2026ailedMessages()\n        }");
        return completable;
    }

    @NotNull
    public final Single<List<String>> findCacheAroundMessageId(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return new MessageLocalDataStore().findCacheAroundMessage(messageId);
    }

    private static final String deleteMessage$lambda$0(String $messageId) {
        Intrinsics.checkNotNullParameter((Object)$messageId, (String)"$messageId");
        String deletingId = "";
        EkoMessageEntity message = new MessageLocalDataStore().getMessage($messageId);
        if (message == null || Intrinsics.areEqual((Object)message.getSyncState(), (Object)AmityMessage.State.SYNCED.getStateName())) {
            deletingId = $messageId;
        }
        return deletingId;
    }

    private static final Unit deleteFailedMessages$lambda$4() {
        new MessageLocalDataStore().cleanUpFailedMessages();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Completable access$fetchMessageMarker(MessageRepository $this, MessageQueryDto dto) {
        return $this.fetchMessageMarker(dto);
    }

    public static final /* synthetic */ List access$getFileUploadingTypes$cp() {
        return fileUploadingTypes;
    }

    static {
        AmityMessage.DataType[] dataTypeArray = new AmityMessage.DataType[]{AmityMessage.DataType.IMAGE, AmityMessage.DataType.FILE, AmityMessage.DataType.AUDIO, AmityMessage.DataType.VIDEO};
        fileUploadingTypes = CollectionsKt.listOf((Object[])dataTypeArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/message/MessageRepository$Companion;", "", "()V", "fileUploadingTypes", "", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

