/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.notificationtray;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.core.data.notificationtray.NotificationTrayLocalDataStore;
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTrayItemEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012\u00a8\u0006\u0013"}, d2={"Lcom/amity/socialcloud/sdk/core/data/notificationtray/NotificationTrayLocalDataStore;", "", "()V", "getNotificationTrayItem", "Lcom/amity/socialcloud/sdk/entity/core/notificationtray/NotificationTrayItemEntity;", "notificationId", "", "getNotificationTrayItemPagingSource", "Landroidx/paging/PagingSource;", "", "markSeen", "Lio/reactivex/rxjava3/core/Completable;", "lastSeenAt", "Lorg/joda/time/DateTime;", "observe", "Lio/reactivex/rxjava3/core/Flowable;", "saveNotificationTrayItems", "items", "", "amity-sdk_release"})
public final class NotificationTrayLocalDataStore {
    @NotNull
    public final Flowable<NotificationTrayItemEntity> observe(@NotNull String notificationId) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Flowable flowable = UserDatabase.get().notificationTrayItemDao().observeNotificationTrayItem(notificationId).map((Function)observe.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"get().notificationTrayIt\u2026          }\n            }");
        return flowable;
    }

    @Nullable
    public final NotificationTrayItemEntity getNotificationTrayItem(@NotNull String notificationId) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Ref.ObjectRef notificationTrayItem = new Ref.ObjectRef();
        Completable.fromCallable(() -> NotificationTrayLocalDataStore.getNotificationTrayItem$lambda$0(notificationId, notificationTrayItem)).subscribeOn(Schedulers.io()).blockingAwait();
        return (NotificationTrayItemEntity)notificationTrayItem.element;
    }

    @NotNull
    public final Completable saveNotificationTrayItems(@NotNull List<? extends NotificationTrayItemEntity> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Completable completable = Completable.fromAction(() -> NotificationTrayLocalDataStore.saveNotificationTrayItems$lambda$1(items));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction { UserDatabas\u2026ayItemDao().save(items) }");
        return completable;
    }

    @NotNull
    public final PagingSource<Integer, NotificationTrayItemEntity> getNotificationTrayItemPagingSource() {
        return UserDatabase.get().notificationTrayItemPagingDao().queryNotificationTrayItems();
    }

    @NotNull
    public final Completable markSeen(@NotNull String notificationId, @NotNull DateTime lastSeenAt) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)lastSeenAt, (String)"lastSeenAt");
        Completable completable = Completable.fromAction(() -> NotificationTrayLocalDataStore.markSeen$lambda$2(notificationId, lastSeenAt));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026)\n            }\n        }");
        return completable;
    }

    private static final Unit getNotificationTrayItem$lambda$0(String $notificationId, Ref.ObjectRef $notificationTrayItem) {
        Intrinsics.checkNotNullParameter((Object)$notificationId, (String)"$notificationId");
        Intrinsics.checkNotNullParameter((Object)$notificationTrayItem, (String)"$notificationTrayItem");
        NotificationTrayItemEntity notiItem = UserDatabase.get().notificationTrayItemDao().getByIdNow($notificationId);
        if (notiItem != null) {
            $notificationTrayItem.element = notiItem;
        }
        return Unit.INSTANCE;
    }

    private static final void saveNotificationTrayItems$lambda$1(List $items) {
        Intrinsics.checkNotNullParameter((Object)$items, (String)"$items");
        UserDatabase.get().notificationTrayItemDao().save($items);
    }

    private static final void markSeen$lambda$2(String $notificationId, DateTime $lastSeenAt) {
        NotificationTrayItemEntity currentSeen;
        Intrinsics.checkNotNullParameter((Object)$notificationId, (String)"$notificationId");
        Intrinsics.checkNotNullParameter((Object)$lastSeenAt, (String)"$lastSeenAt");
        NotificationTrayItemEntity notificationTrayItemEntity = currentSeen = UserDatabase.get().notificationTrayItemDao().getByIdNow($notificationId);
        if ((notificationTrayItemEntity != null ? notificationTrayItemEntity.getLastSeenAt() : null) == null || $lastSeenAt.isAfter((ReadableInstant)currentSeen.getLastSeenAt())) {
            UserDatabase.get().notificationTrayItemDao().markAsSeen($notificationId, $lastSeenAt);
        }
    }
}

