/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.story;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.social.story.AmityStorySortOption;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.entity.social.story.StoryEntity;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.social.story.AmityStory;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryImageDisplayMode;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryItem;
import com.amity.socialcloud.sdk.social.data.story.StoryLocalDataStore;
import com.amity.socialcloud.sdk.social.data.story.StoryMediator;
import com.amity.socialcloud.sdk.social.data.story.StoryModelMapper;
import com.amity.socialcloud.sdk.social.data.story.StoryRemoteDataStore;
import com.amity.socialcloud.sdk.social.data.story.StoryRepository;
import com.amity.socialcloud.sdk.social.data.story.StorySinglePageMediator;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.paging.SinglePagePagerCreator;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004JL\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J@\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J6\u0010\u0016\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011JD\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\"\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\u001f\u001a\u00020\u0007J*\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\"0!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u0018\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u0018\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J3\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020&H\u0000\u00a2\u0006\u0002\b.J4\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000e0!2\u0018\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007010\u000e2\u0006\u00102\u001a\u00020$J\u0010\u00103\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0007J\u0016\u00104\u001a\u00020&2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u0014\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000306H\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u0012\u00108\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u000e\u00109\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0007J\u0016\u0010:\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010;\u001a\u00020<\u00a8\u0006="}, d2={"Lcom/amity/socialcloud/sdk/social/data/story/StoryRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/amity/socialcloud/sdk/entity/social/story/StoryEntity;", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory;", "()V", "createImageStory", "Lio/reactivex/rxjava3/core/Single;", "", "referenceId", "targetType", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory$TargetType;", "targetId", "fileId", "storyItems", "", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryItem;", "metadata", "Lcom/google/gson/JsonObject;", "imageDisplayMode", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryImageDisplayMode;", "createLocalImageStory", "Lio/reactivex/rxjava3/core/Completable;", "createLocalVideoStory", "createVideoStory", "deleteStory", "storyId", "permanent", "", "fetchAndSave", "objectId", "findCache", "generateUniqueId", "getActiveStories", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/story/AmityStorySortOption;", "getFailedStoriesCount", "", "getHighestStoryExpiresAt", "Lorg/joda/time/DateTime;", "getHighestSyncedStoryExpiresAt", "getLatestStories", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "getLatestStories$amity_sdk_release", "getStoriesByTargets", "targets", "Lkotlin/Pair;", "orderBy", "getStoryNow", "getSyncingStoriesCount", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "queryFromCache", "triggerStoryReload", "updateStorySyncState", "syncState", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory$State;", "amity-sdk_release"})
public final class StoryRepository
extends AmityObjectRepository<StoryEntity, AmityStory> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new StoryRemoteDataStore().getStory(objectId).flatMapCompletable((Function)fetchAndSave.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"StoryRemoteDataStore().g\u2026persist(it)\n            }");
        return completable;
    }

    @Override
    @Nullable
    public StoryEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        StoryEntity story = new StoryLocalDataStore().getStoryNow(objectId);
        if (story != null && AmityStory.State.Companion.enumOf(story.getSyncState()) != AmityStory.State.SYNCED) {
            throw AmityException.Companion.create$default(AmityException.Companion, "Observing unsynced object is not supported by Live Object.", null, AmityError.UNSUPPORTED, null, 8, null);
        }
        return story;
    }

    @Override
    @NotNull
    public ModelMapper<StoryEntity, AmityStory> mapper() {
        return new StoryModelMapper();
    }

    @Override
    @NotNull
    public Flowable<StoryEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new StoryLocalDataStore().observeStory(objectId);
    }

    @NotNull
    public final String generateUniqueId() {
        return "LOCAL_" + UUID.randomUUID();
    }

    @NotNull
    public final Completable createLocalImageStory(@NotNull String referenceId, @NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull List<? extends AmityStoryItem> storyItems, @Nullable JsonObject metadata, @NotNull AmityStoryImageDisplayMode imageDisplayMode) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter(storyItems, (String)"storyItems");
        Intrinsics.checkNotNullParameter((Object)((Object)imageDisplayMode), (String)"imageDisplayMode");
        return new StoryLocalDataStore().createImageStory(referenceId, targetType, targetId, storyItems, metadata, imageDisplayMode);
    }

    public static /* synthetic */ Completable createLocalImageStory$default(StoryRepository storyRepository, String string, AmityStory.TargetType targetType, String string2, List list2, JsonObject jsonObject, AmityStoryImageDisplayMode amityStoryImageDisplayMode, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return storyRepository.createLocalImageStory(string, targetType, string2, list2, jsonObject, amityStoryImageDisplayMode);
    }

    @NotNull
    public final Single<String> createImageStory(@NotNull String referenceId, @NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull String fileId, @NotNull List<? extends AmityStoryItem> storyItems, @Nullable JsonObject metadata, @NotNull AmityStoryImageDisplayMode imageDisplayMode) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter(storyItems, (String)"storyItems");
        Intrinsics.checkNotNullParameter((Object)((Object)imageDisplayMode), (String)"imageDisplayMode");
        Single single = new StoryRemoteDataStore().createImageStory(referenceId, targetType, targetId, fileId, storyItems, metadata, imageDisplayMode).flatMap((Function)createImageStory.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"StoryRemoteDataStore().c\u2026yId ?: \"\"))\n            }");
        return single;
    }

    @NotNull
    public final Completable updateStorySyncState(@NotNull String referenceId, @NotNull AmityStory.State syncState) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)syncState), (String)"syncState");
        return new StoryLocalDataStore().updateStorySyncState(referenceId, syncState);
    }

    @NotNull
    public final Completable createLocalVideoStory(@NotNull String referenceId, @NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull List<? extends AmityStoryItem> storyItems, @Nullable JsonObject metadata) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter(storyItems, (String)"storyItems");
        return new StoryLocalDataStore().createVideoStory(referenceId, targetType, targetId, storyItems, metadata);
    }

    @NotNull
    public final Single<String> createVideoStory(@NotNull String referenceId, @NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull String fileId, @NotNull List<? extends AmityStoryItem> storyItems, @Nullable JsonObject metadata) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter(storyItems, (String)"storyItems");
        Single single = new StoryRemoteDataStore().createVideoStory(referenceId, targetType, targetId, fileId, storyItems, metadata).flatMap((Function)createVideoStory.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"StoryRemoteDataStore().c\u2026yId ?: \"\"))\n            }");
        return single;
    }

    @NotNull
    public final Flowable<PagingData<AmityStory>> getActiveStories(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull AmityStorySortOption sortOption) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(100, 0, true, 100, 0, 0, 48, null), null, new StoryMediator(targetType, targetId, sortOption), (Function0)new Function0<PagingSource<Integer, StoryEntity>>(targetType, targetId, sortOption){
            final /* synthetic */ AmityStory.TargetType $targetType;
            final /* synthetic */ String $targetId;
            final /* synthetic */ AmityStorySortOption $sortOption;
            {
                this.$targetType = $targetType;
                this.$targetId = $targetId;
                this.$sortOption = $sortOption;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, StoryEntity> invoke() {
                return new StoryLocalDataStore().getStoryPagingSource(this.$targetType, this.$targetId, this.$sortOption);
            }
        }, (ModelMapper)new StoryModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Completable deleteStory(@NotNull String storyId, boolean permanent) {
        Completable completable;
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        Completable deleteCache = new StoryLocalDataStore().deleteStory(storyId);
        if (StringsKt.startsWith$default((String)storyId, (String)"LOCAL_", (boolean)false, (int)2, null)) {
            completable = deleteCache;
        } else {
            Completable completable2 = new StoryRemoteDataStore().deleteStory(storyId, permanent).ignoreElement().andThen((CompletableSource)deleteCache);
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n            StoryRemot\u2026en(deleteCache)\n        }");
        }
        return completable;
    }

    @NotNull
    public final Flowable<AmityStory> getLatestStories$amity_sdk_release(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable flowable = new StoryLocalDataStore().getLatestStories(targetType, targetId, ((Object)dynamicQueryStreamKeyCreator.toMap()).hashCode(), nonce).map((Function)getLatestStories.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"StoryLocalDataStore().ge\u2026r().map(it)\n            }");
        return flowable;
    }

    @Nullable
    public final AmityStory getStoryNow(@NotNull String storyId) {
        AmityStory amityStory;
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        StoryEntity storyEntity = new StoryLocalDataStore().getStoryNow(storyId);
        if (storyEntity != null) {
            StoryEntity it = storyEntity;
            boolean bl = false;
            amityStory = new StoryModelMapper().map(it);
        } else {
            amityStory = null;
        }
        return amityStory;
    }

    public final int getSyncingStoriesCount(@NotNull AmityStory.TargetType targetType, @NotNull String targetId) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return new StoryLocalDataStore().getStoryCount(targetType, targetId, CollectionsKt.listOf((Object)((Object)AmityStory.State.SYNCING)));
    }

    public final int getFailedStoriesCount(@NotNull AmityStory.TargetType targetType, @NotNull String targetId) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return new StoryLocalDataStore().getStoryCount(targetType, targetId, CollectionsKt.listOf((Object)((Object)AmityStory.State.FAILED)));
    }

    @Nullable
    public final DateTime getHighestStoryExpiresAt(@NotNull AmityStory.TargetType targetType, @NotNull String targetId) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        AmityStory.State[] stateArray = new AmityStory.State[]{AmityStory.State.FAILED, AmityStory.State.SYNCING};
        return new StoryLocalDataStore().getHighestStoryExpiresAt(targetType, targetId, CollectionsKt.listOf((Object[])stateArray));
    }

    @Nullable
    public final DateTime getHighestSyncedStoryExpiresAt(@NotNull AmityStory.TargetType targetType, @NotNull String targetId) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return new StoryLocalDataStore().getHighestStoryExpiresAt(targetType, targetId, CollectionsKt.listOf((Object)((Object)AmityStory.State.SYNCED)));
    }

    @NotNull
    public final Completable triggerStoryReload(@NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        return new StoryLocalDataStore().triggerStoryReload(storyId);
    }

    @NotNull
    public final Single<List<String>> findCache(@NotNull AmityStory.TargetType targetType, @NotNull String targetId) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return new StoryLocalDataStore().findCache(targetType, targetId);
    }

    @NotNull
    public final Flowable<List<AmityStory>> getStoriesByTargets(@NotNull List<? extends Pair<? extends AmityStory.TargetType, String>> targets, @NotNull AmityStorySortOption orderBy) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)((Object)orderBy), (String)"orderBy");
        SinglePagePagerCreator pagerCreator2 = new SinglePagePagerCreator(new StorySinglePageMediator(targets, orderBy), new StoryLocalDataStore().getStoriesByTargets(targets), new StoryModelMapper());
        return pagerCreator2.create();
    }
}

