package com.amity.socialcloud.sdk.socket.util

import androidx.room.TypeConverter
import com.google.gson.*
import org.joda.time.DateTime
import java.lang.reflect.Type

class DateTimeTypeConverter : JsonDeserializer<DateTime>, JsonSerializer<DateTime> {
    @TypeConverter
    fun stringToDateTime(dateTimeString: String?): DateTime? {
		return dateTimeString?.let { DateTime(it) }
    }

	@TypeConverter
	fun dateTimeToString(dateTime: DateTime?): String? {
		return dateTime?.toString()
	}

	@Throws(JsonParseException::class)
	override fun deserialize(json: JsonElement, typeOfT: Type, context: JsonDeserializationContext): DateTime {
		return DateTime(json.asJsonPrimitive.asString)
	}

	override fun serialize(src: DateTime, typeOfSrc: Type, context: JsonSerializationContext): JsonElement {
		return JsonPrimitive(src.toString())
	}
}