/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.presentation;

import android.content.Context;
import android.net.Uri;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import androidx.annotation.OptIn;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Player;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.source.ConcatenatingMediaSource;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.ProgressiveMediaSource;
import androidx.media3.extractor.DefaultExtractorsFactory;
import androidx.media3.extractor.ExtractorsFactory;
import androidx.media3.ui.PlayerView;
import com.amity.socialcloud.sdk.streamapi.PartialStreamData;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.amity.socialcloud.sdk.video.StreamPlayerClient;
import com.ekoapp.sdk.streamplayer.R;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableInterval;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0006\u0010 \u001a\u00020\u0017J\b\u0010!\u001a\u00020\"H\u0002J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020\u0017H\u0002J\b\u0010&\u001a\u00020\u0017H\u0002J\u0006\u0010'\u001a\u00020\u0017J\u000e\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0019J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0019H\u0002J\u0016\u0010+\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190-H\u0002J\u0006\u0010.\u001a\u00020\u0017J\u0010\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u0012H\u0002J\u0014\u00101\u001a\u00020\u00172\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u000e\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020$J\u0010\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u00020\u0017H\u0002J\u0006\u00108\u001a\u00020\u0017J\b\u00109\u001a\u00020\u0017H\u0002J\b\u0010:\u001a\u00020\u0017H\u0002J!\u0010;\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010<\u001a\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010=R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/amity/socialcloud/sdk/video/presentation/AmityVideoPlayer;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "duration", "", "durationDisposable", "Lio/reactivex/rxjava3/disposables/Disposable;", "exoplayer", "Landroidx/media3/exoplayer/ExoPlayer;", "isStopWhenPause", "", "isStopped", "isVideoPlaying", "onClose", "Lkotlin/Function0;", "", "sessionId", "", "startedAt", "Lorg/joda/time/DateTime;", "kotlin.jvm.PlatformType", "title", "applyPlayer", "isLive", "enableStopWhenPause", "getDataSourceFactory", "Landroidx/media3/datasource/DataSource$Factory;", "getVolume", "", "inflateView", "initPlayer", "pause", "play", "streamId", "prepareStream", "prepareVideo", "urls", "", "resume", "seekToLastWhenResume", "isPlaying", "setOnClose", "setVolume", "volume", "starCounting", "partialStreamData", "Lcom/amity/socialcloud/sdk/streamapi/PartialStreamData;", "startInterval", "stop", "stopCounting", "syncPendingSession", "updateStreamSession", "endedAt", "(Ljava/lang/Long;Lorg/joda/time/DateTime;)V", "amity-video-player_release"})
@OptIn(markerClass={UnstableApi.class})
@SourceDebugExtension(value={"SMAP\nAmityVideoPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmityVideoPlayer.kt\ncom/amity/socialcloud/sdk/video/presentation/AmityVideoPlayer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,258:1\n1855#2,2:259\n*S KotlinDebug\n*F\n+ 1 AmityVideoPlayer.kt\ncom/amity/socialcloud/sdk/video/presentation/AmityVideoPlayer\n*L\n149#1:259,2\n*E\n"})
public final class AmityVideoPlayer
extends LinearLayout {
    @Nullable
    private ExoPlayer exoplayer;
    private boolean isStopped;
    private boolean isVideoPlaying;
    private boolean isStopWhenPause;
    private DateTime startedAt;
    private long duration;
    @Nullable
    private Disposable durationDisposable;
    @NotNull
    private String title;
    @Nullable
    private String sessionId;
    @Nullable
    private Function0<Unit> onClose;

    public AmityVideoPlayer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.startedAt = DateTime.now();
        this.title = "";
        this.inflateView();
    }

    public AmityVideoPlayer(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.startedAt = DateTime.now();
        this.title = "";
        this.inflateView();
    }

    public AmityVideoPlayer(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.startedAt = DateTime.now();
        this.title = "";
        this.inflateView();
    }

    private final void inflateView() {
        LinearLayout.inflate((Context)this.getContext(), (int)R.layout.view_amity_video_player, (ViewGroup)((ViewGroup)this));
    }

    public final void play(@NotNull String streamId) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        this.stopCounting();
        this.initPlayer();
        this.prepareStream(streamId);
    }

    public final void stop() {
        ExoPlayer exoPlayer = this.exoplayer;
        if (exoPlayer != null) {
            exoPlayer.stop();
        }
        this.stopCounting();
    }

    public final void pause() {
        block1: {
            ExoPlayer exoPlayer = this.exoplayer;
            if (exoPlayer != null) {
                exoPlayer.setPlayWhenReady(false);
            }
            ExoPlayer exoPlayer2 = this.exoplayer;
            if (exoPlayer2 == null) break block1;
            exoPlayer2.getPlaybackState();
        }
    }

    public final void resume() {
        block1: {
            ExoPlayer exoPlayer = this.exoplayer;
            if (exoPlayer != null) {
                exoPlayer.setPlayWhenReady(true);
            }
            ExoPlayer exoPlayer2 = this.exoplayer;
            if (exoPlayer2 == null) break block1;
            exoPlayer2.getPlaybackState();
        }
    }

    public final void enableStopWhenPause() {
        this.isStopWhenPause = true;
    }

    public final void setVolume(float volume) {
        ExoPlayer exoPlayer = this.exoplayer;
        if (exoPlayer != null) {
            exoPlayer.setVolume(volume);
        }
    }

    public final float getVolume() {
        ExoPlayer exoPlayer = this.exoplayer;
        return exoPlayer != null ? exoPlayer.getVolume() : 0.0f;
    }

    public final void setOnClose(@NotNull Function0<Unit> onClose) {
        Intrinsics.checkNotNullParameter(onClose, (String)"onClose");
        this.onClose = onClose;
    }

    private final void initPlayer() {
        block1: {
            ExoPlayer exoPlayer = this.exoplayer = new ExoPlayer.Builder(this.getContext()).build();
            if (exoPlayer != null) {
                exoPlayer.addListener(new Player.Listener(this){
                    final /* synthetic */ AmityVideoPlayer this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onIsPlayingChanged(boolean isPlaying) {
                        AmityVideoPlayer.access$setVideoPlaying$p(this.this$0, isPlaying);
                        if (AmityVideoPlayer.access$isStopWhenPause$p(this.this$0)) {
                            AmityVideoPlayer.access$seekToLastWhenResume(this.this$0, isPlaying);
                        }
                    }
                });
            }
            AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(3).build();
            boolean bl = false;
            ExoPlayer exoPlayer2 = this.exoplayer;
            if (exoPlayer2 == null) break block1;
            exoPlayer2.setAudioAttributes(audioAttributes, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void seekToLastWhenResume(boolean isPlaying) {
        if (isPlaying) {
            ExoPlayer exoPlayer = this.exoplayer;
            boolean bl = exoPlayer != null ? exoPlayer.getPlaybackState() == 3 : false;
            if (bl) {
                if (!this.isStopped) return;
                ExoPlayer exoPlayer2 = this.exoplayer;
                if (exoPlayer2 != null) {
                    exoPlayer2.seekTo(Long.MAX_VALUE);
                }
                this.isStopped = false;
                return;
            }
        }
        if (isPlaying) return;
        ExoPlayer exoPlayer = this.exoplayer;
        if (!(exoPlayer != null ? exoPlayer.getPlaybackState() == 3 : false)) return;
        this.isStopped = true;
    }

    private final void prepareVideo(List<String> urls) {
        ConcatenatingMediaSource concatenatedSource = new ConcatenatingMediaSource(new MediaSource[0]);
        Iterable $this$forEach$iv = urls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaItem mediaItem;
            String url = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)MediaItem.fromUri((Uri)Uri.parse((String)url)), (String)"fromUri(Uri.parse(url))");
            ProgressiveMediaSource progressiveMediaSource = new ProgressiveMediaSource.Factory(this.getDataSourceFactory(), (ExtractorsFactory)new DefaultExtractorsFactory()).createMediaSource(mediaItem);
            Intrinsics.checkNotNullExpressionValue((Object)progressiveMediaSource, (String)"Factory(getDataSourceFac\u2026ateMediaSource(mediaItem)");
            MediaSource videoSource = (MediaSource)progressiveMediaSource;
            concatenatedSource.addMediaSource(videoSource);
        }
        ExoPlayer exoPlayer = this.exoplayer;
        if (exoPlayer != null) {
            exoPlayer.setMediaSource((MediaSource)concatenatedSource);
        }
        ExoPlayer exoPlayer2 = this.exoplayer;
        if (exoPlayer2 != null) {
            exoPlayer2.prepare();
        }
        ExoPlayer exoPlayer3 = this.exoplayer;
        if (exoPlayer3 != null) {
            exoPlayer3.setPlayWhenReady(true);
        }
    }

    private final DataSource.Factory getDataSourceFactory() {
        DefaultHttpDataSource.Factory factory = new DefaultHttpDataSource.Factory().setUserAgent(Util.getUserAgent((Context)this.getContext(), (String)((Object)((Object)this)).getClass().getSimpleName())).setAllowCrossProtocolRedirects(true);
        Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"Factory()\n            .s\u2026ssProtocolRedirects(true)");
        return (DataSource.Factory)factory;
    }

    private final void prepareStream(String streamId) {
        if (this.durationDisposable == null) {
            StreamPlayerClient.Companion.getFunction().getStreamData(streamId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doOnSuccess(new Consumer(this){
                final /* synthetic */ AmityVideoPlayer this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(@NotNull PartialStreamData streamData) {
                    Intrinsics.checkNotNullParameter((Object)streamData, (String)"streamData");
                    Collection collection = streamData.getWatchingUrls();
                    if (!(collection == null || collection.isEmpty())) {
                        AmityVideoPlayer.access$applyPlayer(this.this$0, streamData.isLive());
                        List list = streamData.getWatchingUrls();
                        Intrinsics.checkNotNull((Object)list);
                        AmityVideoPlayer.access$prepareVideo(this.this$0, list);
                        AmityVideoPlayer.access$starCounting(this.this$0, streamData);
                    }
                }
            }).subscribe();
        }
    }

    private final void applyPlayer(boolean isLive) {
        ImageButton closeButton;
        PlayerView viewer = (PlayerView)this.findViewById(isLive ? R.id.amity_live_video_viewer : R.id.amity_recorded_video_viewer);
        viewer.setVisibility(0);
        viewer.setPlayer((Player)this.exoplayer);
        PlayerView playerView = viewer;
        ImageButton imageButton = closeButton = playerView != null ? (ImageButton)playerView.findViewById(R.id.exo_close) : null;
        if (closeButton != null && this.onClose != null) {
            closeButton.setVisibility(0);
            closeButton.setOnClickListener(arg_0 -> AmityVideoPlayer.applyPlayer$lambda$2(this, arg_0));
        }
        viewer.requestFocus();
    }

    private final void starCounting(PartialStreamData partialStreamData) {
        StreamFunctionInterface streamFunctionInterface = StreamPlayerClient.Companion.getFunction();
        String string = partialStreamData.getStreamId();
        DateTime dateTime = this.startedAt;
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"startedAt");
        streamFunctionInterface.createStreamSession(string, this.title, dateTime, partialStreamData.getResolution()).subscribeOn(Schedulers.io()).doOnSuccess(new Consumer(this){
            final /* synthetic */ AmityVideoPlayer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AmityVideoPlayer.access$setSessionId$p(this.this$0, it);
                AmityVideoPlayer.access$startInterval(this.this$0);
            }
        }).subscribe();
    }

    private final void startInterval() {
        this.startedAt = DateTime.now();
        this.durationDisposable = new FlowableInterval(0L, 1L, TimeUnit.SECONDS, Schedulers.io()).filter(new Predicate(this){
            final /* synthetic */ AmityVideoPlayer this$0;
            {
                this.this$0 = $receiver;
            }

            public final boolean test(long it) {
                return AmityVideoPlayer.access$isVideoPlaying$p(this.this$0);
            }
        }).map(new Function(this){
            final /* synthetic */ AmityVideoPlayer this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final Long apply(long it) {
                AmityVideoPlayer amityVideoPlayer = this.this$0;
                long l = AmityVideoPlayer.access$getDuration$p(amityVideoPlayer);
                AmityVideoPlayer.access$setDuration$p(amityVideoPlayer, l + 1L);
                return l;
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doOnNext(new Consumer(this){
            final /* synthetic */ AmityVideoPlayer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(long it) {
                DateTime endedAt = DateTime.now();
                AmityVideoPlayer.access$updateStreamSession(this.this$0, it, endedAt);
            }
        }).subscribe();
    }

    private final void stopCounting() {
        Disposable disposable = this.durationDisposable;
        boolean bl = disposable != null ? !disposable.isDisposed() : false;
        if (bl) {
            Disposable disposable2 = this.durationDisposable;
            if (disposable2 != null) {
                disposable2.dispose();
            }
            if (this.duration > 0L) {
                DateTime endedAt = DateTime.now();
                String startTimeText = ((Object)DateFormat.format((CharSequence)"MMMM dd yyyy, h:mm aa", (long)this.startedAt.getMillis())).toString();
                String endTimeText = ((Object)DateFormat.format((CharSequence)"MMMM dd yyyy, h:mm aa", (long)endedAt.getMillis())).toString();
                String summaryText = " Start time : " + startTimeText + "\n End time : " + endTimeText + "\n Duration in second : " + this.duration;
                this.updateStreamSession(this.duration, endedAt);
                this.syncPendingSession();
            }
        }
    }

    private final void updateStreamSession(Long duration, DateTime endedAt) {
        block0: {
            String string = this.sessionId;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            StreamPlayerClient.Companion.getFunction().updateStreamSession(it, duration, endedAt).subscribeOn(Schedulers.io()).subscribe();
        }
    }

    private final void syncPendingSession() {
        StreamPlayerClient.Companion.getFunction().syncPendingSession();
    }

    private static final void applyPlayer$lambda$2(AmityVideoPlayer this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Function0<Unit> function0 = this$0.onClose;
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    public static final /* synthetic */ void access$setVideoPlaying$p(AmityVideoPlayer $this, boolean bl) {
        $this.isVideoPlaying = bl;
    }

    public static final /* synthetic */ boolean access$isStopWhenPause$p(AmityVideoPlayer $this) {
        return $this.isStopWhenPause;
    }

    public static final /* synthetic */ void access$seekToLastWhenResume(AmityVideoPlayer $this, boolean isPlaying) {
        $this.seekToLastWhenResume(isPlaying);
    }

    public static final /* synthetic */ void access$applyPlayer(AmityVideoPlayer $this, boolean isLive) {
        $this.applyPlayer(isLive);
    }

    public static final /* synthetic */ void access$prepareVideo(AmityVideoPlayer $this, List urls) {
        $this.prepareVideo(urls);
    }

    public static final /* synthetic */ void access$starCounting(AmityVideoPlayer $this, PartialStreamData partialStreamData) {
        $this.starCounting(partialStreamData);
    }

    public static final /* synthetic */ void access$setSessionId$p(AmityVideoPlayer $this, String string) {
        $this.sessionId = string;
    }

    public static final /* synthetic */ void access$startInterval(AmityVideoPlayer $this) {
        $this.startInterval();
    }

    public static final /* synthetic */ boolean access$isVideoPlaying$p(AmityVideoPlayer $this) {
        return $this.isVideoPlaying;
    }

    public static final /* synthetic */ long access$getDuration$p(AmityVideoPlayer $this) {
        return $this.duration;
    }

    public static final /* synthetic */ void access$setDuration$p(AmityVideoPlayer $this, long l) {
        $this.duration = l;
    }

    public static final /* synthetic */ void access$updateStreamSession(AmityVideoPlayer $this, Long duration, DateTime endedAt) {
        $this.updateStreamSession(duration, endedAt);
    }
}

