/*
 * Decompiled with CFR 0.152.
 */
package com.amity.coremedia.iso;

import com.amity.coremedia.iso.BoxParser;
import com.amity.coremedia.iso.ChannelHelper;
import com.amity.coremedia.iso.IsoFile;
import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.coremedia.iso.boxes.Box;
import com.amity.coremedia.iso.boxes.ContainerBox;
import com.amity.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;

public abstract class AbstractBoxParser
implements BoxParser {
    private static Logger LOG = Logger.getLogger(AbstractBoxParser.class.getName());

    public abstract Box createBox(String var1, byte[] var2, String var3);

    @Override
    public Box parseBox(ReadableByteChannel byteChannel, ContainerBox parent) throws IOException {
        long contentSize;
        ByteBuffer bb;
        ByteBuffer header = ChannelHelper.readFully(byteChannel, 8L);
        long size = IsoTypeReader.readUInt32(header);
        if (size < 8L && size > 1L) {
            LOG.severe("Plausibility check failed: size < 8 (size = " + size + "). Stop parsing!");
            return null;
        }
        String type = IsoTypeReader.read4cc(header);
        byte[] usertype = null;
        if (size == 1L) {
            bb = ByteBuffer.allocate(8);
            byteChannel.read(bb);
            bb.rewind();
            size = IsoTypeReader.readUInt64(bb);
            contentSize = size - 16L;
        } else if (size == 0L) {
            if (!(byteChannel instanceof FileChannel)) {
                throw new RuntimeException("Only FileChannel inputs may use size == 0 (box reaches to the end of file)");
            }
            size = ((FileChannel)byteChannel).size() - ((FileChannel)byteChannel).position() - 8L;
            contentSize = size - 8L;
        } else {
            contentSize = size - 8L;
        }
        if ("uuid".equals(type)) {
            bb = ByteBuffer.allocate(16);
            byteChannel.read(bb);
            bb.rewind();
            usertype = bb.array();
            contentSize -= 16L;
        }
        Box box = this.createBox(type, usertype, parent.getType());
        box.setParent(parent);
        LOG.finest("Parsing " + box.getType());
        if (CastUtils.l2i(size - contentSize) == 8) {
            header.rewind();
        } else if (CastUtils.l2i(size - contentSize) == 16) {
            header = ByteBuffer.allocate(16);
            IsoTypeWriter.writeUInt32(header, 1L);
            header.put(IsoFile.fourCCtoBytes(type));
            IsoTypeWriter.writeUInt64(header, size);
        } else if (CastUtils.l2i(size - contentSize) == 24) {
            header = ByteBuffer.allocate(24);
            IsoTypeWriter.writeUInt32(header, size);
            header.put(IsoFile.fourCCtoBytes(type));
            header.put(usertype);
        } else if (CastUtils.l2i(size - contentSize) == 32) {
            header = ByteBuffer.allocate(32);
            IsoTypeWriter.writeUInt32(header, size);
            header.put(IsoFile.fourCCtoBytes(type));
            IsoTypeWriter.writeUInt64(header, size);
            header.put(usertype);
        } else {
            throw new RuntimeException("I didn't expect that");
        }
        box.parse(byteChannel, header, contentSize, this);
        assert (size == box.getSize()) : "Reconstructed Size is not x to the number of parsed bytes! (" + box.getType() + ") Actual Box size: " + size + " Calculated size: " + box.getSize();
        return box;
    }
}

