/*
 * Decompiled with CFR 0.152.
 */
package com.amity.github.faucamp.simplertmp;

import android.os.Handler;
import android.os.Message;
import java.io.IOException;
import java.net.SocketException;

public class RtmpHandler
extends Handler {
    private static final int MSG_RTMP_CONNECTING = 0;
    private static final int MSG_RTMP_CONNECTED = 1;
    private static final int MSG_RTMP_VIDEO_STREAMING = 2;
    private static final int MSG_RTMP_AUDIO_STREAMING = 3;
    private static final int MSG_RTMP_STOPPED = 4;
    private static final int MSG_RTMP_DISCONNECTED = 5;
    private static final int MSG_RTMP_VIDEO_FPS_CHANGED = 6;
    private static final int MSG_RTMP_VIDEO_BITRATE_CHANGED = 7;
    private static final int MSG_RTMP_AUDIO_BITRATE_CHANGED = 8;
    private static final int MSG_RTMP_SOCKET_EXCEPTION = 9;
    private static final int MSG_RTMP_IO_EXCEPTION = 10;
    private static final int MSG_RTMP_ILLEGAL_ARGUMENT_EXCEPTION = 11;
    private static final int MSG_RTMP_ILLEGAL_STATE_EXCEPTION = 12;
    private RtmpListener mWeakListener;

    public RtmpHandler(RtmpListener listener) {
        this.mWeakListener = listener;
    }

    public void notifyRtmpConnecting(String msg) {
        this.obtainMessage(0, msg).sendToTarget();
    }

    public void notifyRtmpConnected(String msg) {
        this.obtainMessage(1, msg).sendToTarget();
    }

    public void notifyRtmpVideoStreaming() {
        this.sendEmptyMessage(2);
    }

    public void notifyRtmpAudioStreaming() {
        this.sendEmptyMessage(3);
    }

    public void notifyRtmpStopped() {
        this.sendEmptyMessage(4);
    }

    public void notifyRtmpDisconnected() {
        this.sendEmptyMessage(5);
    }

    public void notifyRtmpVideoFpsChanged(double fps) {
        this.obtainMessage(6, fps).sendToTarget();
    }

    public void notifyRtmpVideoBitrateChanged(double bitrate) {
        this.obtainMessage(7, bitrate).sendToTarget();
    }

    public void notifyRtmpAudioBitrateChanged(double bitrate) {
        this.obtainMessage(8, bitrate).sendToTarget();
    }

    public void notifyRtmpSocketException(SocketException e) {
        this.obtainMessage(9, e).sendToTarget();
    }

    public void notifyRtmpIOException(IOException e) {
        this.obtainMessage(10, e).sendToTarget();
    }

    public void notifyRtmpIllegalArgumentException(IllegalArgumentException e) {
        this.obtainMessage(11, e).sendToTarget();
    }

    public void notifyRtmpIllegalStateException(IllegalStateException e) {
        this.obtainMessage(12, e).sendToTarget();
    }

    public void handleMessage(Message msg) {
        RtmpListener listener = this.mWeakListener;
        if (listener == null) {
            return;
        }
        switch (msg.what) {
            case 0: {
                listener.onRtmpConnecting((String)msg.obj);
                break;
            }
            case 1: {
                listener.onRtmpConnected((String)msg.obj);
                break;
            }
            case 2: {
                listener.onRtmpVideoStreaming();
                break;
            }
            case 3: {
                listener.onRtmpAudioStreaming();
                break;
            }
            case 4: {
                listener.onRtmpStopped();
                break;
            }
            case 5: {
                listener.onRtmpDisconnected();
                break;
            }
            case 6: {
                listener.onRtmpVideoFpsChanged((Double)msg.obj);
                break;
            }
            case 7: {
                listener.onRtmpVideoBitrateChanged((Double)msg.obj);
                break;
            }
            case 8: {
                listener.onRtmpAudioBitrateChanged((Double)msg.obj);
                break;
            }
            case 9: {
                listener.onRtmpSocketException((SocketException)msg.obj);
                break;
            }
            case 10: {
                listener.onRtmpIOException((IOException)msg.obj);
                break;
            }
            case 11: {
                listener.onRtmpIllegalArgumentException((IllegalArgumentException)msg.obj);
                break;
            }
            case 12: {
                listener.onRtmpIllegalStateException((IllegalStateException)msg.obj);
                break;
            }
            default: {
                throw new RuntimeException("unknown msg " + msg.what);
            }
        }
    }

    public static interface RtmpListener {
        public void onRtmpConnecting(String var1);

        public void onRtmpConnected(String var1);

        public void onRtmpVideoStreaming();

        public void onRtmpAudioStreaming();

        public void onRtmpStopped();

        public void onRtmpDisconnected();

        public void onRtmpVideoFpsChanged(double var1);

        public void onRtmpVideoBitrateChanged(double var1);

        public void onRtmpAudioBitrateChanged(double var1);

        public void onRtmpSocketException(SocketException var1);

        public void onRtmpIOException(IOException var1);

        public void onRtmpIllegalArgumentException(IllegalArgumentException var1);

        public void onRtmpIllegalStateException(IllegalStateException var1);
    }
}

