/*
 * Decompiled with CFR 0.152.
 */
package net.ossrs.yasea;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.amity.coremedia.iso.BoxParser;
import com.amity.coremedia.iso.IsoFile;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.amity.coremedia.iso.boxes.Box;
import com.amity.coremedia.iso.boxes.ContainerBox;
import com.amity.coremedia.iso.boxes.DataEntryUrlBox;
import com.amity.coremedia.iso.boxes.DataInformationBox;
import com.amity.coremedia.iso.boxes.DataReferenceBox;
import com.amity.coremedia.iso.boxes.FileTypeBox;
import com.amity.coremedia.iso.boxes.HandlerBox;
import com.amity.coremedia.iso.boxes.MediaBox;
import com.amity.coremedia.iso.boxes.MediaHeaderBox;
import com.amity.coremedia.iso.boxes.MediaInformationBox;
import com.amity.coremedia.iso.boxes.MovieBox;
import com.amity.coremedia.iso.boxes.MovieHeaderBox;
import com.amity.coremedia.iso.boxes.SampleDescriptionBox;
import com.amity.coremedia.iso.boxes.SampleSizeBox;
import com.amity.coremedia.iso.boxes.SampleTableBox;
import com.amity.coremedia.iso.boxes.SampleToChunkBox;
import com.amity.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.amity.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.amity.coremedia.iso.boxes.SyncSampleBox;
import com.amity.coremedia.iso.boxes.TimeToSampleBox;
import com.amity.coremedia.iso.boxes.TrackBox;
import com.amity.coremedia.iso.boxes.TrackHeaderBox;
import com.amity.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.amity.coremedia.iso.boxes.h264.AvcConfigurationBox;
import com.amity.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.amity.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.amity.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.SLConfigDescriptor;
import com.amity.googlecode.mp4parser.util.Math;
import com.amity.googlecode.mp4parser.util.Matrix;
import com.amity.socialcloud.sdk.log.AmityLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.ossrs.yasea.SrsRecordHandler;

public class SrsMp4Muxer {
    private static final String TAG = "SrsMp4Muxer";
    private static final int VIDEO_TRACK = 100;
    private static final int AUDIO_TRACK = 101;
    private File mRecFile;
    private SrsRecordHandler mHandler;
    private MediaFormat videoFormat = null;
    private MediaFormat audioFormat = null;
    private SrsRawH264Stream avc = new SrsRawH264Stream();
    private Mp4Movie mp4Movie = new Mp4Movie();
    private boolean aacSpecConfig = false;
    private ByteBuffer h264_sps = null;
    private ByteBuffer h264_pps = null;
    private ArrayList<byte[]> spsList = new ArrayList();
    private ArrayList<byte[]> ppsList = new ArrayList();
    private Thread worker;
    private volatile boolean bRecording = false;
    private volatile boolean bPaused = false;
    private volatile boolean needToFindKeyFrame = true;
    private final Object writeLock = new Object();
    private ConcurrentLinkedQueue<SrsEsFrame> frameCache = new ConcurrentLinkedQueue();
    private static Map<Integer, Integer> samplingFrequencyIndexMap = new HashMap<Integer, Integer>();
    private InterleaveChunkMdat mdat = null;
    private FileOutputStream fos = null;
    private FileChannel fc = null;
    private volatile long recFileSize = 0L;
    private volatile long mdatOffset = 0L;
    private volatile long flushBytes = 0L;
    private HashMap<Track, long[]> track2SampleSizes = new HashMap();

    public SrsMp4Muxer(SrsRecordHandler handler) {
        this.mHandler = handler;
    }

    public boolean record(File outputFile) {
        if (this.videoFormat == null && this.audioFormat == null) {
            return false;
        }
        this.mRecFile = outputFile;
        this.createMovie(this.mRecFile);
        this.mHandler.notifyRecordStarted(this.mRecFile.getPath());
        if (!this.spsList.isEmpty() && !this.ppsList.isEmpty()) {
            this.mp4Movie.addTrack(this.videoFormat, false);
        }
        this.mp4Movie.addTrack(this.audioFormat, true);
        this.worker = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SrsMp4Muxer.this.bRecording = true;
                while (SrsMp4Muxer.this.bRecording) {
                    while (!SrsMp4Muxer.this.frameCache.isEmpty()) {
                        SrsEsFrame frame = SrsMp4Muxer.this.frameCache.poll();
                        SrsMp4Muxer.this.writeSampleData(frame.bb, frame.bi, frame.is_audio());
                    }
                    Object object = SrsMp4Muxer.this.writeLock;
                    synchronized (object) {
                        try {
                            SrsMp4Muxer.this.writeLock.wait(500L);
                        }
                        catch (InterruptedException ie) {
                            SrsMp4Muxer.this.worker.interrupt();
                        }
                    }
                }
            }
        });
        this.worker.start();
        return true;
    }

    public void pause() {
        if (this.bRecording) {
            this.bPaused = true;
            this.mHandler.notifyRecordPause();
        }
    }

    public void resume() {
        if (this.bRecording) {
            this.bPaused = false;
            this.needToFindKeyFrame = true;
            this.mHandler.notifyRecordResume();
        }
    }

    public void stop() {
        this.bRecording = false;
        this.bPaused = false;
        this.needToFindKeyFrame = true;
        this.aacSpecConfig = false;
        this.frameCache.clear();
        if (this.worker != null) {
            try {
                this.worker.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.worker.interrupt();
            }
            this.worker = null;
            this.finishMovie();
            this.mHandler.notifyRecordFinished(this.mRecFile.getPath());
        }
        AmityLog.INSTANCE.tag(TAG).i("SrsMp4Muxer closed", new Object[0]);
    }

    public int addTrack(MediaFormat format) {
        if (format.getString("mime").contentEquals("video/avc")) {
            this.videoFormat = format;
            return 100;
        }
        this.audioFormat = format;
        return 101;
    }

    public void writeSampleData(int trackIndex, ByteBuffer byteBuf, MediaCodec.BufferInfo bufferInfo) {
        if (100 == trackIndex) {
            this.writeVideoSample(byteBuf, bufferInfo);
        } else {
            this.writeAudioSample(byteBuf, bufferInfo);
        }
    }

    private void writeVideoSample(ByteBuffer bb, MediaCodec.BufferInfo bi) {
        int nal_unit_type = bb.get(4) & 0x1F;
        if (nal_unit_type == 5 || nal_unit_type == 1) {
            this.writeFrameByte(100, bb, bi, nal_unit_type == 5);
        } else {
            while (bb.position() < bi.size) {
                SrsEsFrameBytes frame = this.avc.annexb_demux(bb, bi);
                if (this.avc.is_sps(frame)) {
                    if (frame.data.equals(this.h264_sps)) continue;
                    byte[] sps = new byte[frame.size];
                    frame.data.get(sps);
                    this.h264_sps = ByteBuffer.wrap(sps);
                    this.spsList.clear();
                    this.spsList.add(sps);
                    continue;
                }
                if (!this.avc.is_pps(frame) || frame.data.equals(this.h264_pps)) continue;
                byte[] pps = new byte[frame.size];
                frame.data.get(pps);
                this.h264_pps = ByteBuffer.wrap(pps);
                this.ppsList.clear();
                this.ppsList.add(pps);
            }
        }
    }

    private void writeAudioSample(ByteBuffer bb, MediaCodec.BufferInfo bi) {
        if (!this.aacSpecConfig) {
            this.aacSpecConfig = true;
        } else {
            this.writeFrameByte(101, bb, bi, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFrameByte(int track, ByteBuffer bb, MediaCodec.BufferInfo bi, boolean isKeyFrame) {
        SrsEsFrame frame = new SrsEsFrame();
        frame.bb = bb;
        frame.bi = bi;
        frame.isKeyFrame = isKeyFrame;
        frame.track = track;
        if (this.bRecording && !this.bPaused) {
            if (this.needToFindKeyFrame) {
                if (frame.isKeyFrame) {
                    this.needToFindKeyFrame = false;
                    this.frameCache.add(frame);
                    Object object = this.writeLock;
                    synchronized (object) {
                        this.writeLock.notifyAll();
                    }
                }
            } else {
                this.frameCache.add(frame);
                Object object = this.writeLock;
                synchronized (object) {
                    this.writeLock.notifyAll();
                }
            }
        }
    }

    private void createMovie(File outputFile) {
        try {
            this.fos = new FileOutputStream(outputFile);
            this.fc = this.fos.getChannel();
            this.mdat = new InterleaveChunkMdat();
            this.mdatOffset = 0L;
            FileTypeBox fileTypeBox = this.createFileTypeBox();
            fileTypeBox.getBox(this.fc);
            this.recFileSize += fileTypeBox.getSize();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.mHandler.notifyRecordIOException(e);
        }
    }

    private void writeSampleData(ByteBuffer byteBuf, MediaCodec.BufferInfo bi, boolean isAudio) {
        int trackIndex;
        int n = trackIndex = isAudio ? 101 : 100;
        if (!this.mp4Movie.getTracks().containsKey(trackIndex)) {
            return;
        }
        try {
            if (this.mdat.first) {
                this.mdat.setContentSize(0L);
                this.mdat.getBox(this.fc);
                this.mdatOffset = this.recFileSize;
                this.recFileSize += (long)this.mdat.getHeaderSize();
                this.mdat.first = false;
            }
            this.mp4Movie.addSample(trackIndex, this.recFileSize, bi);
            byteBuf.position(bi.offset + (isAudio ? 0 : 4));
            byteBuf.limit(bi.offset + bi.size);
            if (!isAudio) {
                ByteBuffer size = ByteBuffer.allocate(4);
                size.position(0);
                size.putInt(bi.size - 4);
                size.position(0);
                this.recFileSize += (long)this.fc.write(size);
            }
            int writeBytes = this.fc.write(byteBuf);
            this.recFileSize += (long)writeBytes;
            this.flushBytes += (long)writeBytes;
            if (this.flushBytes > 65536L) {
                this.fos.flush();
                this.flushBytes = 0L;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.mHandler.notifyRecordIOException(e);
        }
    }

    private void finishMovie() {
        try {
            if (this.flushBytes > 0L) {
                this.fos.flush();
                this.flushBytes = 0L;
            }
            if (this.mdat.getSize() != 0L) {
                long oldPosition = this.fc.position();
                this.fc.position(this.mdatOffset);
                this.mdat.setContentSize(this.recFileSize - (long)this.mdat.getHeaderSize() - this.mdatOffset);
                this.mdat.getBox(this.fc);
                this.fc.position(oldPosition);
                this.mdat.setContentSize(0L);
                this.fos.flush();
            }
            for (Track track : this.mp4Movie.getTracks().values()) {
                ArrayList<Sample> samples = track.getSamples();
                long[] sizes = new long[samples.size()];
                for (int i = 0; i < sizes.length; ++i) {
                    sizes[i] = ((Sample)samples.get(i)).getSize();
                }
                this.track2SampleSizes.put(track, sizes);
            }
            MovieBox moov = this.createMovieBox(this.mp4Movie);
            moov.getBox(this.fc);
            this.fos.flush();
            this.fc.close();
            this.fos.close();
            this.mp4Movie.getTracks().clear();
            this.track2SampleSizes.clear();
            this.recFileSize = 0L;
            this.flushBytes = 0L;
        }
        catch (IOException e) {
            this.mHandler.notifyRecordIOException(e);
        }
    }

    private FileTypeBox createFileTypeBox() {
        LinkedList<String> minorBrands = new LinkedList<String>();
        minorBrands.add("isom");
        minorBrands.add("3gp4");
        return new FileTypeBox("isom", 0L, minorBrands);
    }

    private long getTimescale(Mp4Movie mp4Movie) {
        long timescale = 0L;
        if (!mp4Movie.getTracks().isEmpty()) {
            timescale = mp4Movie.getTracks().values().iterator().next().getTimeScale();
        }
        for (Track track : mp4Movie.getTracks().values()) {
            timescale = Math.gcd((long)track.getTimeScale(), timescale);
        }
        return timescale;
    }

    private MovieBox createMovieBox(Mp4Movie movie) {
        MovieBox movieBox = new MovieBox();
        MovieHeaderBox mvhd = new MovieHeaderBox();
        mvhd.setCreationTime(new Date());
        mvhd.setModificationTime(new Date());
        mvhd.setMatrix(Matrix.ROTATE_0);
        long movieTimeScale = this.getTimescale(movie);
        long duration = 0L;
        for (Track track : movie.getTracks().values()) {
            long tracksDuration = track.getDuration() * movieTimeScale / (long)track.getTimeScale();
            if (tracksDuration <= duration) continue;
            duration = tracksDuration;
        }
        mvhd.setDuration(duration);
        mvhd.setTimescale(movieTimeScale);
        mvhd.setNextTrackId(movie.getTracks().size() + 1);
        movieBox.addBox(mvhd);
        for (Track track : movie.getTracks().values()) {
            movieBox.addBox(this.createTrackBox(track, movie));
        }
        return movieBox;
    }

    private TrackBox createTrackBox(Track track, Mp4Movie movie) {
        TrackBox trackBox = new TrackBox();
        TrackHeaderBox tkhd = new TrackHeaderBox();
        tkhd.setEnabled(true);
        tkhd.setInMovie(true);
        tkhd.setInPreview(true);
        if (track.isAudio()) {
            tkhd.setMatrix(Matrix.ROTATE_0);
        } else {
            tkhd.setMatrix(movie.getMatrix());
        }
        tkhd.setAlternateGroup(0);
        tkhd.setCreationTime(track.getCreationTime());
        tkhd.setModificationTime(track.getCreationTime());
        tkhd.setDuration(track.getDuration() * this.getTimescale(movie) / (long)track.getTimeScale());
        tkhd.setHeight(track.getHeight());
        tkhd.setWidth(track.getWidth());
        tkhd.setLayer(0);
        tkhd.setModificationTime(new Date());
        tkhd.setTrackId(track.getTrackId() + 1);
        tkhd.setVolume(track.getVolume());
        trackBox.addBox(tkhd);
        MediaBox mdia = new MediaBox();
        trackBox.addBox(mdia);
        MediaHeaderBox mdhd = new MediaHeaderBox();
        mdhd.setCreationTime(track.getCreationTime());
        mdhd.setModificationTime(track.getCreationTime());
        mdhd.setDuration(track.getDuration());
        mdhd.setTimescale(track.getTimeScale());
        mdhd.setLanguage("eng");
        mdia.addBox(mdhd);
        HandlerBox hdlr = new HandlerBox();
        hdlr.setName(track.isAudio() ? "SoundHandle" : "VideoHandle");
        hdlr.setHandlerType(track.getHandler());
        mdia.addBox(hdlr);
        MediaInformationBox minf = new MediaInformationBox();
        minf.addBox(track.getMediaHeaderBox());
        DataInformationBox dinf = new DataInformationBox();
        DataReferenceBox dref = new DataReferenceBox();
        dinf.addBox(dref);
        DataEntryUrlBox url = new DataEntryUrlBox();
        url.setFlags(1);
        dref.addBox(url);
        minf.addBox(dinf);
        Box stbl = this.createStbl(track);
        minf.addBox(stbl);
        mdia.addBox(minf);
        return trackBox;
    }

    private Box createStbl(Track track) {
        SampleTableBox stbl = new SampleTableBox();
        this.createStsd(track, stbl);
        this.createStts(track, stbl);
        this.createStss(track, stbl);
        this.createStsc(track, stbl);
        this.createStsz(track, stbl);
        this.createStco(track, stbl);
        return stbl;
    }

    private void createStsd(Track track, SampleTableBox stbl) {
        stbl.addBox(track.getSampleDescriptionBox());
    }

    private void createStts(Track track, SampleTableBox stbl) {
        TimeToSampleBox.Entry lastEntry = null;
        ArrayList<TimeToSampleBox.Entry> entries = new ArrayList<TimeToSampleBox.Entry>();
        for (long delta : track.getSampleDurations()) {
            if (lastEntry != null && lastEntry.getDelta() == delta) {
                lastEntry.setCount(lastEntry.getCount() + 1L);
                continue;
            }
            lastEntry = new TimeToSampleBox.Entry(1L, delta);
            entries.add(lastEntry);
        }
        TimeToSampleBox stts = new TimeToSampleBox();
        stts.setEntries(entries);
        stbl.addBox(stts);
    }

    private void createStss(Track track, SampleTableBox stbl) {
        long[] syncSamples = track.getSyncSamples();
        if (syncSamples != null && syncSamples.length > 0) {
            SyncSampleBox stss = new SyncSampleBox();
            stss.setSampleNumber(syncSamples);
            stbl.addBox(stss);
        }
    }

    private void createStsc(Track track, SampleTableBox stbl) {
        SampleToChunkBox stsc = new SampleToChunkBox();
        stsc.setEntries(new LinkedList<SampleToChunkBox.Entry>());
        int lastChunkNumber = 1;
        int lastSampleCount = 0;
        int previousWritedChunkCount = -1;
        int samplesCount = track.getSamples().size();
        for (int a = 0; a < samplesCount; ++a) {
            Sample sample = track.getSamples().get(a);
            long offset = sample.getOffset();
            long size = sample.getSize();
            long lastOffset = offset + size;
            ++lastSampleCount;
            boolean write = false;
            if (a != samplesCount - 1) {
                Sample nextSample = track.getSamples().get(a + 1);
                if (lastOffset != nextSample.getOffset()) {
                    write = true;
                }
            } else {
                write = true;
            }
            if (!write) continue;
            if (previousWritedChunkCount != lastSampleCount) {
                stsc.getEntries().add(new SampleToChunkBox.Entry(lastChunkNumber, lastSampleCount, 1L));
                previousWritedChunkCount = lastSampleCount;
            }
            lastSampleCount = 0;
            ++lastChunkNumber;
        }
        stbl.addBox(stsc);
    }

    private void createStsz(Track track, SampleTableBox stbl) {
        SampleSizeBox stsz = new SampleSizeBox();
        stsz.setSampleSizes(this.track2SampleSizes.get(track));
        stbl.addBox(stsz);
    }

    private void createStco(Track track, SampleTableBox stbl) {
        ArrayList<Long> chunksOffsets = new ArrayList<Long>();
        long lastOffset = -1L;
        for (Sample sample : track.getSamples()) {
            long offset = sample.getOffset();
            if (lastOffset != -1L && lastOffset != offset) {
                lastOffset = -1L;
            }
            if (lastOffset == -1L) {
                chunksOffsets.add(offset);
            }
            lastOffset = offset + sample.getSize();
        }
        long[] chunkOffsetsLong = new long[chunksOffsets.size()];
        for (int a = 0; a < chunksOffsets.size(); ++a) {
            chunkOffsetsLong[a] = (Long)chunksOffsets.get(a);
        }
        StaticChunkOffsetBox stco = new StaticChunkOffsetBox();
        stco.setChunkOffsets(chunkOffsetsLong);
        stbl.addBox(stco);
    }

    static {
        samplingFrequencyIndexMap.put(96000, 0);
        samplingFrequencyIndexMap.put(88200, 1);
        samplingFrequencyIndexMap.put(64000, 2);
        samplingFrequencyIndexMap.put(48000, 3);
        samplingFrequencyIndexMap.put(44100, 4);
        samplingFrequencyIndexMap.put(32000, 5);
        samplingFrequencyIndexMap.put(24000, 6);
        samplingFrequencyIndexMap.put(22050, 7);
        samplingFrequencyIndexMap.put(16000, 8);
        samplingFrequencyIndexMap.put(12000, 9);
        samplingFrequencyIndexMap.put(11025, 10);
        samplingFrequencyIndexMap.put(8000, 11);
    }

    private class SrsRawH264Stream {
        private SrsRawH264Stream() {
        }

        public boolean is_sps(SrsEsFrameBytes frame) {
            if (frame.size < 1) {
                return false;
            }
            return (frame.data.get(0) & 0x1F) == 7;
        }

        public boolean is_pps(SrsEsFrameBytes frame) {
            if (frame.size < 1) {
                return false;
            }
            return (frame.data.get(0) & 0x1F) == 8;
        }

        public SrsAnnexbSearch srs_avc_startswith_annexb(ByteBuffer bb, MediaCodec.BufferInfo bi) {
            SrsAnnexbSearch as = new SrsAnnexbSearch();
            as.match = false;
            for (int pos = bb.position(); pos < bi.size - 3 && bb.get(pos) == 0 && bb.get(pos + 1) == 0; ++pos) {
                if (bb.get(pos + 2) != 1) continue;
                as.match = true;
                as.nb_start_code = pos + 3 - bb.position();
                break;
            }
            return as;
        }

        public SrsEsFrameBytes annexb_demux(ByteBuffer bb, MediaCodec.BufferInfo bi) {
            SrsEsFrameBytes tbb;
            block3: {
                tbb = new SrsEsFrameBytes();
                if (bb.position() >= bi.size) break block3;
                SrsAnnexbSearch tbbsc = this.srs_avc_startswith_annexb(bb, bi);
                if (!tbbsc.match || tbbsc.nb_start_code < 3) {
                    AmityLog.INSTANCE.tag(SrsMp4Muxer.TAG).e("annexb not match.", new Object[0]);
                    SrsMp4Muxer.this.mHandler.notifyRecordIllegalArgumentException(new IllegalArgumentException(String.format("annexb not match for %dB, pos=%d", bi.size, bb.position())));
                }
                ByteBuffer tbbs = bb.slice();
                for (int i = 0; i < tbbsc.nb_start_code; ++i) {
                    bb.get();
                }
                tbb.data = bb.slice();
                int pos = bb.position();
                while (bb.position() < bi.size) {
                    SrsAnnexbSearch bsc = this.srs_avc_startswith_annexb(bb, bi);
                    if (bsc.match) break;
                    bb.get();
                }
                tbb.size = bb.position() - pos;
            }
            return tbb;
        }
    }

    private class Mp4Movie {
        private Matrix matrix = Matrix.ROTATE_0;
        private HashMap<Integer, Track> tracks = new HashMap();

        private Mp4Movie() {
        }

        public Matrix getMatrix() {
            return this.matrix;
        }

        public HashMap<Integer, Track> getTracks() {
            return this.tracks;
        }

        public void addSample(int trackIndex, long offset, MediaCodec.BufferInfo bi) {
            Track track = this.tracks.get(trackIndex);
            track.addSample(offset, bi);
        }

        public void addTrack(MediaFormat format, boolean isAudio) {
            if (format != null) {
                if (isAudio) {
                    this.tracks.put(101, new Track(this.tracks.size(), format, true));
                } else {
                    this.tracks.put(100, new Track(this.tracks.size(), format, false));
                }
            }
        }

        public void removeTrack(int trackIndex) {
            this.tracks.remove(trackIndex);
        }
    }

    private class InterleaveChunkMdat
    implements Box {
        private boolean first = true;
        private ContainerBox parent;
        private ByteBuffer header = ByteBuffer.allocate(16);
        private long contentSize = 0x40000000L;

        private InterleaveChunkMdat() {
        }

        @Override
        public ContainerBox getParent() {
            return this.parent;
        }

        @Override
        public void setParent(ContainerBox parent) {
            this.parent = parent;
        }

        public void setContentSize(long contentSize) {
            this.contentSize = contentSize;
        }

        public long getContentSize() {
            return this.contentSize;
        }

        @Override
        public String getType() {
            return "mdat";
        }

        @Override
        public long getSize() {
            return (long)this.header.limit() + this.contentSize;
        }

        public int getHeaderSize() {
            return this.header.limit();
        }

        private boolean isSmallBox(long contentSize) {
            return contentSize + (long)this.header.limit() < 0x100000000L;
        }

        @Override
        public void getBox(WritableByteChannel writableByteChannel) {
            this.header.rewind();
            long size = this.getSize();
            if (this.isSmallBox(size)) {
                IsoTypeWriter.writeUInt32(this.header, size);
            } else {
                IsoTypeWriter.writeUInt32(this.header, 1L);
            }
            this.header.put(IsoFile.fourCCtoBytes("mdat"));
            if (this.isSmallBox(size)) {
                this.header.put(new byte[8]);
            } else {
                IsoTypeWriter.writeUInt64(this.header, size);
            }
            this.header.rewind();
            try {
                writableByteChannel.write(this.header);
            }
            catch (IOException e) {
                SrsMp4Muxer.this.mHandler.notifyRecordIOException(e);
            }
        }

        @Override
        public void parse(ReadableByteChannel readableByteChannel, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        }
    }

    private class SrsAvcNaluType {
        public static final int Reserved = 0;
        public static final int NonIDR = 1;
        public static final int DataPartitionA = 2;
        public static final int DataPartitionB = 3;
        public static final int DataPartitionC = 4;
        public static final int IDR = 5;
        public static final int SEI = 6;
        public static final int SPS = 7;
        public static final int PPS = 8;
        public static final int AccessUnitDelimiter = 9;
        public static final int EOSequence = 10;
        public static final int EOStream = 11;
        public static final int FilterData = 12;
        public static final int SPSExt = 13;
        public static final int PrefixNALU = 14;
        public static final int SubsetSPS = 15;
        public static final int LayerWithoutPartition = 19;
        public static final int CodedSliceExt = 20;

        private SrsAvcNaluType() {
        }
    }

    private class SrsEsFrameBytes {
        public ByteBuffer data;
        public int size;

        private SrsEsFrameBytes() {
        }
    }

    private class SrsEsFrame {
        public ByteBuffer bb;
        public MediaCodec.BufferInfo bi;
        public int track;
        public boolean isKeyFrame;

        private SrsEsFrame() {
        }

        public boolean is_video() {
            return this.track == 100;
        }

        public boolean is_audio() {
            return this.track == 101;
        }
    }

    private class Track {
        private int trackId = 0;
        private ArrayList<Sample> samples = new ArrayList();
        private long duration = 0L;
        private String handler;
        private AbstractMediaHeaderBox headerBox = null;
        private SampleDescriptionBox sampleDescriptionBox = null;
        private LinkedList<Integer> syncSamples = null;
        private int timeScale;
        private Date creationTime = new Date();
        private int height;
        private int width;
        private float volume = 0.0f;
        private ArrayList<Long> sampleDurations = new ArrayList();
        private boolean isAudio = false;
        private long lastPresentationTimeUs = 0L;
        private boolean first = true;

        public Track(int id, MediaFormat format, boolean audio) {
            this.trackId = id;
            this.isAudio = audio;
            if (!this.isAudio) {
                this.sampleDurations.add(3015L);
                this.duration = 3015L;
                this.width = format.getInteger("width");
                this.height = format.getInteger("height");
                this.timeScale = 90000;
                this.syncSamples = new LinkedList();
                this.handler = "vide";
                this.headerBox = new VideoMediaHeaderBox();
                this.sampleDescriptionBox = new SampleDescriptionBox();
                if (format.getString("mime").contentEquals("video/avc")) {
                    VisualSampleEntry visualSampleEntry = new VisualSampleEntry("avc1");
                    visualSampleEntry.setDataReferenceIndex(1);
                    visualSampleEntry.setDepth(24);
                    visualSampleEntry.setFrameCount(1);
                    visualSampleEntry.setHorizresolution(72.0);
                    visualSampleEntry.setVertresolution(72.0);
                    visualSampleEntry.setWidth(this.width);
                    visualSampleEntry.setHeight(this.height);
                    visualSampleEntry.setCompressorname("AVC Coding");
                    AvcConfigurationBox avcConfigurationBox = new AvcConfigurationBox();
                    avcConfigurationBox.setConfigurationVersion(1);
                    avcConfigurationBox.setAvcProfileIndication(SrsMp4Muxer.this.h264_sps.get(1));
                    avcConfigurationBox.setProfileCompatibility(0);
                    avcConfigurationBox.setAvcLevelIndication(SrsMp4Muxer.this.h264_sps.get(3));
                    avcConfigurationBox.setLengthSizeMinusOne(3);
                    avcConfigurationBox.setSequenceParameterSets(SrsMp4Muxer.this.spsList);
                    avcConfigurationBox.setPictureParameterSets(SrsMp4Muxer.this.ppsList);
                    avcConfigurationBox.setBitDepthLumaMinus8(-1);
                    avcConfigurationBox.setBitDepthChromaMinus8(-1);
                    avcConfigurationBox.setChromaFormat(-1);
                    avcConfigurationBox.setHasExts(false);
                    visualSampleEntry.addBox(avcConfigurationBox);
                    this.sampleDescriptionBox.addBox(visualSampleEntry);
                }
            } else {
                this.sampleDurations.add(1024L);
                this.duration = 1024L;
                this.volume = 1.0f;
                this.timeScale = format.getInteger("sample-rate");
                this.handler = "soun";
                this.headerBox = new SoundMediaHeaderBox();
                this.sampleDescriptionBox = new SampleDescriptionBox();
                AudioSampleEntry audioSampleEntry = new AudioSampleEntry("mp4a");
                audioSampleEntry.setChannelCount(format.getInteger("channel-count"));
                audioSampleEntry.setSampleRate(format.getInteger("sample-rate"));
                audioSampleEntry.setDataReferenceIndex(1);
                audioSampleEntry.setSampleSize(16);
                ESDescriptorBox esds = new ESDescriptorBox();
                ESDescriptor descriptor = new ESDescriptor();
                descriptor.setEsId(0);
                SLConfigDescriptor slConfigDescriptor = new SLConfigDescriptor();
                slConfigDescriptor.setPredefined(2);
                descriptor.setSlConfigDescriptor(slConfigDescriptor);
                DecoderConfigDescriptor decoderConfigDescriptor = new DecoderConfigDescriptor();
                decoderConfigDescriptor.setObjectTypeIndication(64);
                decoderConfigDescriptor.setStreamType(5);
                decoderConfigDescriptor.setBufferSizeDB(1536);
                decoderConfigDescriptor.setMaxBitRate(96000L);
                decoderConfigDescriptor.setAvgBitRate(96000L);
                AudioSpecificConfig audioSpecificConfig = new AudioSpecificConfig();
                audioSpecificConfig.setAudioObjectType(2);
                audioSpecificConfig.setSamplingFrequencyIndex(samplingFrequencyIndexMap.get((int)audioSampleEntry.getSampleRate()));
                audioSpecificConfig.setChannelConfiguration(audioSampleEntry.getChannelCount());
                decoderConfigDescriptor.setAudioSpecificInfo(audioSpecificConfig);
                descriptor.setDecoderConfigDescriptor(decoderConfigDescriptor);
                ByteBuffer data = descriptor.serialize();
                esds.setEsDescriptor(descriptor);
                esds.setData(data);
                audioSampleEntry.addBox(esds);
                this.sampleDescriptionBox.addBox(audioSampleEntry);
            }
        }

        public void addSample(long offset, MediaCodec.BufferInfo bi) {
            long delta = bi.presentationTimeUs - this.lastPresentationTimeUs;
            if (delta < 0L) {
                return;
            }
            boolean isSyncFrame = !this.isAudio && (bi.flags & 1) != 0;
            this.samples.add(new Sample(offset, bi.size));
            if (this.syncSamples != null && isSyncFrame) {
                this.syncSamples.add(this.samples.size());
            }
            delta = (delta * (long)this.timeScale + 500000L) / 1000000L;
            this.lastPresentationTimeUs = bi.presentationTimeUs;
            if (!this.first) {
                this.sampleDurations.add(this.sampleDurations.size() - 1, delta);
                this.duration += delta;
            }
            this.first = false;
        }

        public void clearSample() {
            this.first = true;
            this.samples.clear();
            this.syncSamples.clear();
            this.sampleDurations.clear();
        }

        public ArrayList<Sample> getSamples() {
            return this.samples;
        }

        public long getDuration() {
            return this.duration;
        }

        public String getHandler() {
            return this.handler;
        }

        public AbstractMediaHeaderBox getMediaHeaderBox() {
            return this.headerBox;
        }

        public SampleDescriptionBox getSampleDescriptionBox() {
            return this.sampleDescriptionBox;
        }

        public long[] getSyncSamples() {
            if (this.syncSamples == null || this.syncSamples.isEmpty()) {
                return null;
            }
            long[] returns = new long[this.syncSamples.size()];
            for (int i = 0; i < this.syncSamples.size(); ++i) {
                returns[i] = this.syncSamples.get(i).intValue();
            }
            return returns;
        }

        public int getTimeScale() {
            return this.timeScale;
        }

        public Date getCreationTime() {
            return this.creationTime;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public float getVolume() {
            return this.volume;
        }

        public ArrayList<Long> getSampleDurations() {
            return this.sampleDurations;
        }

        public boolean isAudio() {
            return this.isAudio;
        }

        public int getTrackId() {
            return this.trackId;
        }
    }

    private class Sample {
        private long offset = 0L;
        private long size = 0L;

        public Sample(long offset, long size) {
            this.offset = offset;
            this.size = size;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getSize() {
            return this.size;
        }
    }

    private class SrsAnnexbSearch {
        public int nb_start_code = 0;
        public boolean match = false;

        private SrsAnnexbSearch() {
        }
    }
}

