package com.amity.socialcloud.sdk.video

import com.amity.socialcloud.sdk.streamapi.PartialStreamData
import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution
import com.amity.socialcloud.sdk.video.model.AmityBroadcasterData
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

internal class StreamBroadcasterRepository {

    fun createVideoStreaming(
        title: String,
        description: String,
        resolution: AmityBroadcastResolution,
        thumbnailFileId: String? = null,
        isSecure: Boolean? = null,
    ): Single<AmityBroadcasterData> {
        return StreamBroadcasterClient.getFunction()
            .createVideoStreaming(title, description, resolution, thumbnailFileId, isSecure)
            .map { AmityBroadcasterData(it.first, it.second) }
    }

    fun getVideoStreaming(streamId: String): Single<PartialStreamData> {
        return StreamBroadcasterClient.getFunction().getStreamData(streamId)
    }

    fun disposeVideoStreaming(streamId: String): Completable {
        return StreamBroadcasterClient.getFunction()
            .disposeVideoStreaming(streamId)
    }
}