package com.amity.socialcloud.sdk.video.domain

import com.amity.socialcloud.sdk.video.StreamBroadcasterRepository
import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution
import com.amity.socialcloud.sdk.video.model.AmityBroadcasterData
import io.reactivex.rxjava3.core.Single


internal class CreateVideoStreamingUC {

    fun execute(
        title: String,
        description: String,
        resolution: AmityBroadcastResolution,
        thumbnailFileId: String? = null,
        isSecure: Boolean? = null
    ): Single<AmityBroadcasterData> {
        return StreamBroadcasterRepository().createVideoStreaming(
            title = title,
            description = description,
            resolution = resolution,
            thumbnailFileId = thumbnailFileId,
            isSecure = isSecure
        )
    }
}