/*
 * Decompiled with CFR 0.152.
 */
package com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import java.nio.ByteBuffer;

public class BitReaderBuffer {
    private ByteBuffer buffer;
    int initialPos;
    int position;

    public BitReaderBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.initialPos = buffer.position();
    }

    public int readBits(int i) {
        int rc;
        int b = this.buffer.get(this.initialPos + this.position / 8);
        int v = b < 0 ? b + 256 : b;
        int left = 8 - this.position % 8;
        if (i <= left) {
            rc = (v << this.position % 8 & 0xFF) >> this.position % 8 + (left - i);
            this.position += i;
        } else {
            int now = left;
            int then = i - left;
            rc = this.readBits(now);
            rc <<= then;
            rc += this.readBits(then);
        }
        this.buffer.position(this.initialPos + (int)Math.ceil((double)this.position / 8.0));
        return rc;
    }

    public int getPosition() {
        return this.position;
    }

    public int byteSync() {
        int left = 8 - this.position % 8;
        if (left == 8) {
            left = 0;
        }
        this.readBits(left);
        return left;
    }

    public int remainingBits() {
        return this.buffer.limit() * 8 - this.position;
    }
}

