/*
 * Decompiled with CFR 0.152.
 */
package com.amity.googlecode.mp4parser.boxes.mp4.samplegrouping;

import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.googlecode.mp4parser.AbstractFullBox;
import com.amity.googlecode.mp4parser.boxes.mp4.samplegrouping.CencSampleEncryptionInformationGroupEntry;
import com.amity.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import com.amity.googlecode.mp4parser.boxes.mp4.samplegrouping.RateShareEntry;
import com.amity.googlecode.mp4parser.boxes.mp4.samplegrouping.RollRecoveryEntry;
import com.amity.googlecode.mp4parser.boxes.mp4.samplegrouping.TemporalLevelEntry;
import com.amity.googlecode.mp4parser.boxes.mp4.samplegrouping.UnknownEntry;
import com.amity.googlecode.mp4parser.boxes.mp4.samplegrouping.VisualRandomAccessEntry;
import com.amity.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class SampleGroupDescriptionBox
extends AbstractFullBox {
    public static final String TYPE = "sgpd";
    private String groupingType;
    private int defaultLength;
    private List<GroupEntry> groupEntries = new LinkedList<GroupEntry>();
    private int descriptionLength;

    public SampleGroupDescriptionBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long size = 8L;
        if (this.getVersion() == 1) {
            size += 4L;
        }
        size += 4L;
        for (GroupEntry groupEntry : this.groupEntries) {
            if (this.getVersion() == 1 && this.defaultLength == 0) {
                size += 4L;
            }
            size += (long)groupEntry.size();
        }
        return size;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(this.groupingType.getBytes());
        if (this.getVersion() == 1) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.defaultLength);
        }
        IsoTypeWriter.writeUInt32(byteBuffer, this.groupEntries.size());
        for (GroupEntry entry : this.groupEntries) {
            if (this.getVersion() == 1 && this.defaultLength == 0) {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.get().limit());
            }
            byteBuffer.put(entry.get());
        }
    }

    @Override
    protected void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        if (this.getVersion() != 1) {
            throw new RuntimeException("SampleGroupDescriptionBox are only supported in version 1");
        }
        this.groupingType = IsoTypeReader.read4cc(content);
        if (this.getVersion() == 1) {
            this.defaultLength = CastUtils.l2i(IsoTypeReader.readUInt32(content));
        }
        long entryCount = IsoTypeReader.readUInt32(content);
        while (entryCount-- > 0L) {
            int length = this.defaultLength;
            if (this.getVersion() == 1) {
                if (this.defaultLength == 0) {
                    length = this.descriptionLength = CastUtils.l2i(IsoTypeReader.readUInt32(content));
                }
            } else {
                throw new RuntimeException("This should be implemented");
            }
            int finalPos = content.position() + length;
            ByteBuffer parseMe = content.slice();
            parseMe.limit(length);
            this.groupEntries.add(this.parseGroupEntry(parseMe, this.groupingType));
            content.position(finalPos);
        }
    }

    private GroupEntry parseGroupEntry(ByteBuffer content, String groupingType) {
        GroupEntry groupEntry = "roll".equals(groupingType) ? new RollRecoveryEntry() : ("rash".equals(groupingType) ? new RateShareEntry() : ("seig".equals(groupingType) ? new CencSampleEncryptionInformationGroupEntry() : ("rap ".equals(groupingType) ? new VisualRandomAccessEntry() : ("tele".equals(groupingType) ? new TemporalLevelEntry() : new UnknownEntry()))));
        ((GroupEntry)groupEntry).parse(content);
        return groupEntry;
    }

    public String getGroupingType() {
        return this.groupingType;
    }

    public void setGroupingType(String groupingType) {
        this.groupingType = groupingType;
    }

    public int getDefaultLength() {
        return this.defaultLength;
    }

    public void setDefaultLength(int defaultLength) {
        this.defaultLength = defaultLength;
    }

    public List<GroupEntry> getGroupEntries() {
        return this.groupEntries;
    }

    public void setGroupEntries(List<GroupEntry> groupEntries) {
        this.groupEntries = groupEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampleGroupDescriptionBox that = (SampleGroupDescriptionBox)o;
        if (this.defaultLength != that.defaultLength) {
            return false;
        }
        if (this.groupEntries != null ? !this.groupEntries.equals(that.groupEntries) : that.groupEntries != null) {
            return false;
        }
        return !(this.groupingType != null ? !this.groupingType.equals(that.groupingType) : that.groupingType != null);
    }

    public int hashCode() {
        int result = this.groupingType != null ? this.groupingType.hashCode() : 0;
        result = 31 * result + this.defaultLength;
        result = 31 * result + (this.groupEntries != null ? this.groupEntries.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SampleGroupDescriptionBox{groupingType='" + this.groupingType + '\'' + ", defaultLength=" + this.defaultLength + ", groupEntries=" + this.groupEntries + '}';
    }
}

