/*
 * Decompiled with CFR 0.152.
 */
package com.amity.coremedia.iso.boxes.sampleentry;

import com.amity.coremedia.iso.IsoFile;
import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.googlecode.mp4parser.AbstractBox;
import java.nio.ByteBuffer;

public class AmrSpecificBox
extends AbstractBox {
    public static final String TYPE = "damr";
    private String vendor;
    private int decoderVersion;
    private int modeSet;
    private int modeChangePeriod;
    private int framesPerSample;

    public AmrSpecificBox() {
        super(TYPE);
    }

    public String getVendor() {
        return this.vendor;
    }

    public int getDecoderVersion() {
        return this.decoderVersion;
    }

    public int getModeSet() {
        return this.modeSet;
    }

    public int getModeChangePeriod() {
        return this.modeChangePeriod;
    }

    public int getFramesPerSample() {
        return this.framesPerSample;
    }

    @Override
    protected long getContentSize() {
        return 9L;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        byte[] v = new byte[4];
        content.get(v);
        this.vendor = IsoFile.bytesToFourCC(v);
        this.decoderVersion = IsoTypeReader.readUInt8(content);
        this.modeSet = IsoTypeReader.readUInt16(content);
        this.modeChangePeriod = IsoTypeReader.readUInt8(content);
        this.framesPerSample = IsoTypeReader.readUInt8(content);
    }

    @Override
    public void getContent(ByteBuffer byteBuffer) {
        byteBuffer.put(IsoFile.fourCCtoBytes(this.vendor));
        IsoTypeWriter.writeUInt8(byteBuffer, this.decoderVersion);
        IsoTypeWriter.writeUInt16(byteBuffer, this.modeSet);
        IsoTypeWriter.writeUInt8(byteBuffer, this.modeChangePeriod);
        IsoTypeWriter.writeUInt8(byteBuffer, this.framesPerSample);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AmrSpecificBox[vendor=").append(this.getVendor());
        buffer.append(";decoderVersion=").append(this.getDecoderVersion());
        buffer.append(";modeSet=").append(this.getModeSet());
        buffer.append(";modeChangePeriod=").append(this.getModeChangePeriod());
        buffer.append(";framesPerSample=").append(this.getFramesPerSample());
        buffer.append("]");
        return buffer.toString();
    }
}

