/*
 * Decompiled with CFR 0.152.
 */
package com.amity.coremedia.iso.boxes.vodafone;

import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.Utf8;
import com.amity.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class LyricsUriBox
extends AbstractFullBox {
    public static final String TYPE = "lrcu";
    private String lyricsUri;

    public LyricsUriBox() {
        super(TYPE);
    }

    public String getLyricsUri() {
        return this.lyricsUri;
    }

    public void setLyricsUri(String lyricsUri) {
        this.lyricsUri = lyricsUri;
    }

    @Override
    protected long getContentSize() {
        return Utf8.utf8StringLengthInBytes(this.lyricsUri) + 5;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.lyricsUri = IsoTypeReader.readString(content);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(Utf8.convert(this.lyricsUri));
        byteBuffer.put((byte)0);
    }

    public String toString() {
        return "LyricsUriBox[lyricsUri=" + this.getLyricsUri() + "]";
    }
}

