/*
 * Decompiled with CFR 0.152.
 */
package com.amity.googlecode.mp4parser.authoring.tracks;

import com.amity.coremedia.iso.boxes.Box;
import com.amity.coremedia.iso.boxes.CompositionTimeToSample;
import com.amity.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.amity.coremedia.iso.boxes.SampleDescriptionBox;
import com.amity.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.amity.coremedia.iso.boxes.SubSampleInformationBox;
import com.amity.coremedia.iso.boxes.TimeToSampleBox;
import com.amity.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.amity.googlecode.mp4parser.authoring.AbstractTrack;
import com.amity.googlecode.mp4parser.authoring.TrackMetaData;
import com.amity.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.SLConfigDescriptor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AACTrackImpl
extends AbstractTrack {
    public static Map<Integer, Integer> samplingFrequencyIndexMap = new HashMap<Integer, Integer>();
    TrackMetaData trackMetaData = new TrackMetaData();
    SampleDescriptionBox sampleDescriptionBox;
    int samplerate;
    int bitrate;
    int channelCount;
    int channelconfig;
    int bufferSizeDB;
    long maxBitRate;
    long avgBitRate;
    private BufferedInputStream inputStream;
    private List<ByteBuffer> samples;
    boolean readSamples = false;
    List<TimeToSampleBox.Entry> stts;
    private String lang = "und";

    public AACTrackImpl(InputStream inputStream, String lang) throws IOException {
        this.lang = lang;
        this.parse(inputStream);
    }

    public AACTrackImpl(InputStream inputStream) throws IOException {
        this.parse(inputStream);
    }

    private void parse(InputStream inputStream) throws IOException {
        this.inputStream = new BufferedInputStream(inputStream);
        this.stts = new LinkedList<TimeToSampleBox.Entry>();
        if (!this.readVariables()) {
            throw new IOException();
        }
        this.samples = new LinkedList<ByteBuffer>();
        if (!this.readSamples()) {
            throw new IOException();
        }
        double packetsPerSecond = (double)this.samplerate / 1024.0;
        double duration = (double)this.samples.size() / packetsPerSecond;
        long dataSize = 0L;
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (int i = 0; i < this.samples.size(); ++i) {
            int size = this.samples.get(i).capacity();
            dataSize += (long)size;
            queue.add(size);
            while ((double)queue.size() > packetsPerSecond) {
                queue.pop();
            }
            if (queue.size() != (int)packetsPerSecond) continue;
            int currSize = 0;
            for (int j = 0; j < queue.size(); ++j) {
                currSize += ((Integer)queue.get(j)).intValue();
            }
            double currBitrate = 8.0 * (double)currSize / (double)queue.size() * packetsPerSecond;
            if (!(currBitrate > (double)this.maxBitRate)) continue;
            this.maxBitRate = (int)currBitrate;
        }
        this.avgBitRate = (int)((double)(8L * dataSize) / duration);
        this.bufferSizeDB = 1536;
        this.sampleDescriptionBox = new SampleDescriptionBox();
        AudioSampleEntry audioSampleEntry = new AudioSampleEntry("mp4a");
        audioSampleEntry.setChannelCount(2);
        audioSampleEntry.setSampleRate(this.samplerate);
        audioSampleEntry.setDataReferenceIndex(1);
        audioSampleEntry.setSampleSize(16);
        ESDescriptorBox esds = new ESDescriptorBox();
        ESDescriptor descriptor = new ESDescriptor();
        descriptor.setEsId(0);
        SLConfigDescriptor slConfigDescriptor = new SLConfigDescriptor();
        slConfigDescriptor.setPredefined(2);
        descriptor.setSlConfigDescriptor(slConfigDescriptor);
        DecoderConfigDescriptor decoderConfigDescriptor = new DecoderConfigDescriptor();
        decoderConfigDescriptor.setObjectTypeIndication(64);
        decoderConfigDescriptor.setStreamType(5);
        decoderConfigDescriptor.setBufferSizeDB(this.bufferSizeDB);
        decoderConfigDescriptor.setMaxBitRate(this.maxBitRate);
        decoderConfigDescriptor.setAvgBitRate(this.avgBitRate);
        AudioSpecificConfig audioSpecificConfig = new AudioSpecificConfig();
        audioSpecificConfig.setAudioObjectType(2);
        audioSpecificConfig.setSamplingFrequencyIndex(samplingFrequencyIndexMap.get(this.samplerate));
        audioSpecificConfig.setChannelConfiguration(this.channelconfig);
        decoderConfigDescriptor.setAudioSpecificInfo(audioSpecificConfig);
        descriptor.setDecoderConfigDescriptor(decoderConfigDescriptor);
        ByteBuffer data = descriptor.serialize();
        esds.setData(data);
        audioSampleEntry.addBox(esds);
        this.sampleDescriptionBox.addBox(audioSampleEntry);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage(this.lang);
        this.trackMetaData.setTimescale(this.samplerate);
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.stts;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "soun";
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.samples;
    }

    @Override
    public Box getMediaHeaderBox() {
        return new SoundMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    private boolean readVariables() throws IOException {
        byte[] data = new byte[100];
        this.inputStream.mark(100);
        if (100 != this.inputStream.read(data, 0, 100)) {
            return false;
        }
        this.inputStream.reset();
        ByteBuffer bb = ByteBuffer.wrap(data);
        BitReaderBuffer brb = new BitReaderBuffer(bb);
        int syncword = brb.readBits(12);
        if (syncword != 4095) {
            return false;
        }
        int id = brb.readBits(1);
        int layer = brb.readBits(2);
        int protectionAbsent = brb.readBits(1);
        int profile = brb.readBits(2);
        this.samplerate = samplingFrequencyIndexMap.get(brb.readBits(4));
        brb.readBits(1);
        this.channelconfig = brb.readBits(3);
        int original = brb.readBits(1);
        int home = brb.readBits(1);
        int emphasis = brb.readBits(2);
        return true;
    }

    private boolean readSamples() throws IOException {
        if (this.readSamples) {
            return true;
        }
        this.readSamples = true;
        byte[] header = new byte[15];
        boolean ret = false;
        this.inputStream.mark(15);
        while (-1 != this.inputStream.read(header)) {
            ret = true;
            ByteBuffer bb = ByteBuffer.wrap(header);
            this.inputStream.reset();
            BitReaderBuffer brb = new BitReaderBuffer(bb);
            int syncword = brb.readBits(12);
            if (syncword != 4095) {
                return false;
            }
            brb.readBits(3);
            int protectionAbsent = brb.readBits(1);
            brb.readBits(14);
            int frameSize = brb.readBits(13);
            int bufferFullness = brb.readBits(11);
            int noBlocks = brb.readBits(2);
            int used = (int)Math.ceil((double)brb.getPosition() / 8.0);
            if (protectionAbsent == 0) {
                used += 2;
            }
            this.inputStream.skip(used);
            byte[] data = new byte[frameSize -= used];
            this.inputStream.read(data);
            this.samples.add(ByteBuffer.wrap(data));
            this.stts.add(new TimeToSampleBox.Entry(1L, 1024L));
            this.inputStream.mark(15);
        }
        return ret;
    }

    public String toString() {
        return "AACTrackImpl{samplerate=" + this.samplerate + ", bitrate=" + this.bitrate + ", channelCount=" + this.channelCount + ", channelconfig=" + this.channelconfig + '}';
    }

    static {
        samplingFrequencyIndexMap.put(96000, 0);
        samplingFrequencyIndexMap.put(88200, 1);
        samplingFrequencyIndexMap.put(64000, 2);
        samplingFrequencyIndexMap.put(48000, 3);
        samplingFrequencyIndexMap.put(44100, 4);
        samplingFrequencyIndexMap.put(32000, 5);
        samplingFrequencyIndexMap.put(24000, 6);
        samplingFrequencyIndexMap.put(22050, 7);
        samplingFrequencyIndexMap.put(16000, 8);
        samplingFrequencyIndexMap.put(12000, 9);
        samplingFrequencyIndexMap.put(11025, 10);
        samplingFrequencyIndexMap.put(8000, 11);
        samplingFrequencyIndexMap.put(0, 96000);
        samplingFrequencyIndexMap.put(1, 88200);
        samplingFrequencyIndexMap.put(2, 64000);
        samplingFrequencyIndexMap.put(3, 48000);
        samplingFrequencyIndexMap.put(4, 44100);
        samplingFrequencyIndexMap.put(5, 32000);
        samplingFrequencyIndexMap.put(6, 24000);
        samplingFrequencyIndexMap.put(7, 22050);
        samplingFrequencyIndexMap.put(8, 16000);
        samplingFrequencyIndexMap.put(9, 12000);
        samplingFrequencyIndexMap.put(10, 11025);
        samplingFrequencyIndexMap.put(11, 8000);
    }
}

